/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.distsql.handler.update;

import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.global.GlobalRuleDefinitionExecutor;
import org.apache.shardingsphere.sql.parser.api.CacheOption;
import org.apache.shardingsphere.sqlfederation.config.SQLFederationRuleConfiguration;
import org.apache.shardingsphere.sqlfederation.distsql.segment.CacheOptionSegment;
import org.apache.shardingsphere.sqlfederation.distsql.statement.updatable.AlterSQLFederationRuleStatement;
import org.apache.shardingsphere.sqlfederation.rule.SQLFederationRule;

public final class AlterSQLFederationRuleExecutor
implements GlobalRuleDefinitionExecutor<AlterSQLFederationRuleStatement, SQLFederationRule> {
    private SQLFederationRule rule;

    public SQLFederationRuleConfiguration buildToBeAlteredRuleConfiguration(AlterSQLFederationRuleStatement sqlStatement) {
        boolean sqlFederationEnabled = null == sqlStatement.getSqlFederationEnabled() ? this.rule.getConfiguration().isSqlFederationEnabled() : sqlStatement.getSqlFederationEnabled().booleanValue();
        boolean allQueryUseSQLFederation = null == sqlStatement.getAllQueryUseSQLFederation() ? this.rule.getConfiguration().isAllQueryUseSQLFederation() : sqlStatement.getAllQueryUseSQLFederation().booleanValue();
        CacheOption executionPlanCache = null == sqlStatement.getExecutionPlanCache() ? this.rule.getConfiguration().getExecutionPlanCache() : this.createCacheOption(this.rule.getConfiguration().getExecutionPlanCache(), sqlStatement.getExecutionPlanCache());
        return new SQLFederationRuleConfiguration(sqlFederationEnabled, allQueryUseSQLFederation, executionPlanCache);
    }

    private CacheOption createCacheOption(CacheOption cacheOption, CacheOptionSegment segment) {
        int initialCapacity = null == segment.getInitialCapacity() ? cacheOption.getInitialCapacity() : segment.getInitialCapacity().intValue();
        long maximumSize = null == segment.getMaximumSize() ? cacheOption.getMaximumSize() : segment.getMaximumSize().longValue();
        return new CacheOption(initialCapacity, maximumSize);
    }

    public Class<AlterSQLFederationRuleStatement> getType() {
        return AlterSQLFederationRuleStatement.class;
    }

    public Class<SQLFederationRule> getRuleClass() {
        return SQLFederationRule.class;
    }

    @Generated
    public void setRule(SQLFederationRule rule) {
        this.rule = rule;
    }
}

