/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.distsql.handler.converter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.shadow.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.config.datasource.ShadowDataSourceConfiguration;
import org.apache.shardingsphere.shadow.config.table.ShadowTableConfiguration;
import org.apache.shardingsphere.shadow.distsql.handler.supporter.ShadowRuleStatementSupporter;
import org.apache.shardingsphere.shadow.distsql.segment.ShadowAlgorithmSegment;
import org.apache.shardingsphere.shadow.distsql.segment.ShadowRuleSegment;

public final class ShadowRuleStatementConverter {
    public static ShadowRuleConfiguration convert(Collection<ShadowRuleSegment> segments) {
        ShadowRuleConfiguration result = new ShadowRuleConfiguration();
        result.setShadowAlgorithms(ShadowRuleStatementConverter.getShadowAlgorithms(segments));
        result.setDataSources(ShadowRuleStatementConverter.getDataSource(segments));
        result.setTables(ShadowRuleStatementConverter.getTables(segments));
        return result;
    }

    private static Map<String, ShadowTableConfiguration> getTables(Collection<ShadowRuleSegment> segments) {
        HashMap<String, ShadowTableConfiguration> result = new HashMap<String, ShadowTableConfiguration>();
        segments.forEach(each -> {
            Map<String, ShadowTableConfiguration> currentRuleTableConfig = each.getShadowTableRules().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ShadowRuleStatementConverter.buildShadowTableConfiguration(each.getRuleName(), entry), ShadowRuleStatementSupporter::mergeConfiguration));
            currentRuleTableConfig.forEach((key, value) -> result.merge((String)key, (ShadowTableConfiguration)value, ShadowRuleStatementSupporter::mergeConfiguration));
        });
        return result;
    }

    private static ShadowTableConfiguration buildShadowTableConfiguration(String ruleName, Map.Entry<String, Collection<ShadowAlgorithmSegment>> entry) {
        return new ShadowTableConfiguration(new ArrayList<String>(Collections.singleton(ruleName)), (Collection)entry.getValue().stream().map(ShadowAlgorithmSegment::getAlgorithmName).collect(Collectors.toList()));
    }

    private static Collection<ShadowDataSourceConfiguration> getDataSource(Collection<ShadowRuleSegment> segments) {
        LinkedList<ShadowDataSourceConfiguration> result = new LinkedList<ShadowDataSourceConfiguration>();
        segments.forEach(each -> result.add(new ShadowDataSourceConfiguration(each.getRuleName(), each.getSource(), each.getShadow())));
        return result;
    }

    private static Map<String, AlgorithmConfiguration> getShadowAlgorithms(Collection<ShadowRuleSegment> segments) {
        return segments.stream().flatMap(each -> each.getShadowTableRules().values().stream()).flatMap(Collection::stream).collect(Collectors.toMap(ShadowAlgorithmSegment::getAlgorithmName, ShadowRuleStatementConverter::buildAlgorithmConfiguration));
    }

    private static AlgorithmConfiguration buildAlgorithmConfiguration(ShadowAlgorithmSegment segment) {
        return new AlgorithmConfiguration(segment.getAlgorithmSegment().getName(), segment.getAlgorithmSegment().getProps());
    }

    @Generated
    private ShadowRuleStatementConverter() {
    }
}

