/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorRuleAware;
import org.apache.shardingsphere.distsql.handler.engine.query.DistSQLQueryExecutor;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.shadow.distsql.statement.ShowShadowAlgorithmsStatement;
import org.apache.shardingsphere.shadow.rule.ShadowRule;

public final class ShowShadowAlgorithmsExecutor
implements DistSQLQueryExecutor<ShowShadowAlgorithmsStatement>,
DistSQLExecutorRuleAware<ShadowRule> {
    private ShadowRule rule;

    public Collection<String> getColumnNames(ShowShadowAlgorithmsStatement sqlStatement) {
        return Arrays.asList("shadow_algorithm_name", "type", "props", "is_default");
    }

    public Collection<LocalDataQueryResultRow> getRows(ShowShadowAlgorithmsStatement sqlStatement, ContextManager contextManager) {
        String defaultAlgorithm = this.rule.getConfiguration().getDefaultShadowAlgorithmName();
        return this.rule.getConfiguration().getShadowAlgorithms().entrySet().stream().map(entry -> new LocalDataQueryResultRow(new Object[]{entry.getKey(), ((AlgorithmConfiguration)entry.getValue()).getType(), ((AlgorithmConfiguration)entry.getValue()).getProps(), ((String)entry.getKey()).equals(defaultAlgorithm)})).collect(Collectors.toList());
    }

    public Class<ShadowRule> getRuleClass() {
        return ShadowRule.class;
    }

    public Class<ShowShadowAlgorithmsStatement> getType() {
        return ShowShadowAlgorithmsStatement.class;
    }

    @Generated
    public void setRule(ShadowRule rule) {
        this.rule = rule;
    }
}

