/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.opengauss.ingest.incremental.wal.position;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.DialectIncrementalPositionManager;
import org.apache.shardingsphere.data.pipeline.opengauss.ingest.incremental.wal.decode.OpenGaussLogSequenceNumber;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.incremental.wal.WALPosition;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.incremental.wal.decode.BaseLogSequenceNumber;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.incremental.wal.position.slot.PostgreSQLSlotManager;
import org.opengauss.replication.LogSequenceNumber;

public final class OpenGaussIncrementalPositionManager
implements DialectIncrementalPositionManager {
    private final PostgreSQLSlotManager slotManager = new PostgreSQLSlotManager("mppdb_decoding");

    public WALPosition init(String data) {
        return new WALPosition((BaseLogSequenceNumber)new OpenGaussLogSequenceNumber(LogSequenceNumber.valueOf((String)data)));
    }

    public WALPosition init(DataSource dataSource, String slotNameSuffix) throws SQLException {
        try (Connection connection = dataSource.getConnection();){
            this.slotManager.create(connection, slotNameSuffix);
            WALPosition wALPosition = this.getWALPosition(connection);
            return wALPosition;
        }
    }

    private WALPosition getWALPosition(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT PG_CURRENT_XLOG_LOCATION()");){
            WALPosition wALPosition;
            block12: {
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    resultSet.next();
                    wALPosition = new WALPosition((BaseLogSequenceNumber)new OpenGaussLogSequenceNumber(LogSequenceNumber.valueOf((String)resultSet.getString(1))));
                    if (resultSet == null) break block12;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return wALPosition;
        }
    }

    public void destroy(DataSource dataSource, String slotNameSuffix) throws SQLException {
        try (Connection connection = dataSource.getConnection();){
            this.slotManager.dropIfExisted(connection, slotNameSuffix);
        }
    }

    public String getDatabaseType() {
        return "openGauss";
    }
}

