/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.admin.executor.variable.charset;

import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.constant.CommonConstants;
import org.apache.shardingsphere.infra.database.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.variable.charset.CharsetVariableProvider;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;

public final class CharsetSetExecutor {
    private final DatabaseType databaseType;
    private final ConnectionSession connectionSession;

    public void set(String variableName, String assignValue) {
        Optional charsetVariableProvider = DatabaseTypedSPILoader.findService(CharsetVariableProvider.class, (DatabaseType)this.databaseType);
        if (charsetVariableProvider.isPresent() && ((CharsetVariableProvider)charsetVariableProvider.get()).isCharsetVariable(variableName)) {
            this.connectionSession.getAttributeMap().attr(CommonConstants.CHARSET_ATTRIBUTE_KEY).set((Object)((CharsetVariableProvider)charsetVariableProvider.get()).parseCharset(assignValue));
        }
    }

    public void set(Map<String, String> variables) {
        Optional charsetVariableProvider = DatabaseTypedSPILoader.findService(CharsetVariableProvider.class, (DatabaseType)this.databaseType);
        if (!charsetVariableProvider.isPresent()) {
            return;
        }
        for (Map.Entry<String, String> entry : variables.entrySet()) {
            if (!((CharsetVariableProvider)charsetVariableProvider.get()).isCharsetVariable(entry.getKey())) continue;
            this.connectionSession.getAttributeMap().attr(CommonConstants.CHARSET_ATTRIBUTE_KEY).set((Object)((CharsetVariableProvider)charsetVariableProvider.get()).parseCharset(entry.getValue()));
        }
    }

    @Generated
    public CharsetSetExecutor(DatabaseType databaseType, ConnectionSession connectionSession) {
        this.databaseType = databaseType;
        this.connectionSession = connectionSession;
    }
}

