/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.data;

import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.proxy.backend.connector.DatabaseConnectorFactory;
import org.apache.shardingsphere.proxy.backend.handler.data.DatabaseBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.data.impl.UnicastDatabaseBackendHandler;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dal.DALStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dal.SetStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.DoStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.MySQLShowCreateTableStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.MySQLShowTableStatusStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.MySQLShowTablesStatement;

public final class DatabaseBackendHandlerFactory {
    public static DatabaseBackendHandler newInstance(QueryContext queryContext, ConnectionSession connectionSession, boolean preferPreparedStatement) {
        SQLStatementContext sqlStatementContext = queryContext.getSqlStatementContext();
        SQLStatement sqlStatement = sqlStatementContext.getSqlStatement();
        if (sqlStatement instanceof DoStatement) {
            return new UnicastDatabaseBackendHandler(queryContext, connectionSession);
        }
        if (sqlStatement instanceof SetStatement && null == connectionSession.getUsedDatabaseName()) {
            return () -> new UpdateResponseHeader(sqlStatement);
        }
        if (sqlStatement instanceof DALStatement && !DatabaseBackendHandlerFactory.isDatabaseRequiredDALStatement(sqlStatement) || sqlStatement instanceof SelectStatement && !((SelectStatement)sqlStatement).getFrom().isPresent()) {
            return new UnicastDatabaseBackendHandler(queryContext, connectionSession);
        }
        return DatabaseConnectorFactory.getInstance().newInstance(queryContext, connectionSession.getDatabaseConnectionManager(), preferPreparedStatement);
    }

    private static boolean isDatabaseRequiredDALStatement(SQLStatement sqlStatement) {
        return sqlStatement instanceof MySQLShowTablesStatement || sqlStatement instanceof MySQLShowTableStatusStatement || sqlStatement instanceof MySQLShowCreateTableStatement;
    }

    @Generated
    private DatabaseBackendHandlerFactory() {
    }
}

