/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.postgresql.packet.handshake;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.postgresql.packet.PostgreSQLPacket;
import org.apache.shardingsphere.db.protocol.postgresql.payload.PostgreSQLPacketPayload;

public final class PostgreSQLComStartupPacket
extends PostgreSQLPacket {
    private static final String DATABASE_NAME_KEY = "database";
    private static final String USER_NAME_KEY = "user";
    private static final String CLIENT_ENCODING_KEY = "client_encoding";
    private final int version;
    private final Map<String, String> parametersMap = new HashMap<String, String>();

    public PostgreSQLComStartupPacket(PostgreSQLPacketPayload payload) {
        payload.skipReserved(4);
        this.version = payload.readInt4();
        while (payload.bytesBeforeZero() > 0) {
            this.parametersMap.put(payload.readStringNul(), payload.readStringNul());
        }
    }

    public String getDatabase() {
        return this.parametersMap.get(DATABASE_NAME_KEY);
    }

    public String getUsername() {
        return this.parametersMap.get(USER_NAME_KEY);
    }

    public String getClientEncoding() {
        return this.parametersMap.getOrDefault(CLIENT_ENCODING_KEY, "UTF8");
    }

    @Override
    protected void write(PostgreSQLPacketPayload payload) {
    }

    @Generated
    public int getVersion() {
        return this.version;
    }
}

