/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.mysql.packet.binlog.row.column.value.string;

import java.io.Serializable;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLBinaryColumnType;
import org.apache.shardingsphere.db.protocol.mysql.packet.binlog.row.column.MySQLBinlogColumnDef;
import org.apache.shardingsphere.db.protocol.mysql.packet.binlog.row.column.value.MySQLBinlogProtocolValue;
import org.apache.shardingsphere.db.protocol.mysql.packet.binlog.row.column.value.string.MySQLBinaryString;
import org.apache.shardingsphere.db.protocol.mysql.payload.MySQLPacketPayload;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;

public final class MySQLStringBinlogProtocolValue
implements MySQLBinlogProtocolValue {
    @Override
    public Serializable read(MySQLBinlogColumnDef columnDef, MySQLPacketPayload payload) {
        int type = columnDef.getColumnMeta() >> 8;
        int length = columnDef.getColumnMeta() & 0xFF;
        if (48 != (type & 0x30)) {
            length += (type & 0x30 ^ 0x30) << 4;
            type |= 0x30;
        }
        switch (MySQLBinaryColumnType.valueOf(type)) {
            case ENUM: {
                return this.readEnumValue(length, payload);
            }
            case SET: {
                return Byte.valueOf(payload.getByteBuf().readByte());
            }
            case STRING: {
                return new MySQLBinaryString(payload.readStringFixByBytes(this.readActualLength(length, payload)));
            }
        }
        throw new UnsupportedSQLOperationException(MySQLBinaryColumnType.valueOf(type).toString());
    }

    private int readActualLength(int length, MySQLPacketPayload payload) {
        return length < 256 ? payload.getByteBuf().readUnsignedByte() : payload.getByteBuf().readUnsignedShortLE();
    }

    private Serializable readEnumValue(int meta, MySQLPacketPayload payload) {
        switch (meta) {
            case 1: {
                return Integer.valueOf(payload.readInt1());
            }
            case 2: {
                return Integer.valueOf(payload.readInt2());
            }
        }
        throw new UnsupportedSQLOperationException(String.format("MySQL Enum meta in binlog only include value 1 or 2, but actual is %s", meta));
    }
}

