/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.mysql.packet.binlog.row.column.value.time;

import java.io.Serializable;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Date;
import org.apache.shardingsphere.db.protocol.mysql.packet.binlog.row.column.MySQLBinlogColumnDef;
import org.apache.shardingsphere.db.protocol.mysql.packet.binlog.row.column.value.MySQLBinlogProtocolValue;
import org.apache.shardingsphere.db.protocol.mysql.payload.MySQLPacketPayload;

public final class MySQLDatetimeBinlogProtocolValue
implements MySQLBinlogProtocolValue {
    @Override
    public Serializable read(MySQLBinlogColumnDef columnDef, MySQLPacketPayload payload) {
        long datetime = payload.readInt8();
        return 0L == datetime ? "0000-00-00 00:00:00" : this.readDateTime(datetime);
    }

    private Date readDateTime(long datetime) {
        int date = (int)(datetime / 1000000L);
        int year = date / 10000;
        int month = date % 10000 / 100;
        int day = date % 100;
        int time = (int)(datetime % 1000000L);
        int hour = time / 10000;
        int minute = time % 10000 / 100;
        int second = time % 100;
        return Timestamp.valueOf(LocalDateTime.of(year, month, day, hour, minute, second));
    }
}

