/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.core.advisor.executor.type;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;
import org.apache.shardingsphere.agent.api.advice.TargetAdviceMethod;
import org.apache.shardingsphere.agent.api.advice.TargetAdviceObject;
import org.apache.shardingsphere.agent.api.advice.type.InstanceMethodAdvice;
import org.apache.shardingsphere.agent.api.plugin.AgentPluginEnable;
import org.apache.shardingsphere.agent.core.advisor.executor.AdviceExecutor;
import org.apache.shardingsphere.shade.net.bytebuddy.description.method.MethodDescription;
import org.apache.shardingsphere.shade.net.bytebuddy.dynamic.DynamicType;
import org.apache.shardingsphere.shade.net.bytebuddy.implementation.MethodDelegation;
import org.apache.shardingsphere.shade.net.bytebuddy.implementation.bind.annotation.AllArguments;
import org.apache.shardingsphere.shade.net.bytebuddy.implementation.bind.annotation.Origin;
import org.apache.shardingsphere.shade.net.bytebuddy.implementation.bind.annotation.RuntimeType;
import org.apache.shardingsphere.shade.net.bytebuddy.implementation.bind.annotation.SuperCall;
import org.apache.shardingsphere.shade.net.bytebuddy.implementation.bind.annotation.This;
import org.apache.shardingsphere.shade.net.bytebuddy.matcher.ElementMatchers;

public final class InstanceMethodAdviceExecutor
implements AdviceExecutor {
    private static final Logger LOGGER = Logger.getLogger(InstanceMethodAdviceExecutor.class.getName());
    private final Map<String, Collection<InstanceMethodAdvice>> advices;

    @RuntimeType
    public Object advice(@This TargetAdviceObject target, @Origin Method method, @AllArguments Object[] args, @SuperCall Callable<?> callable) {
        this.adviceBefore(target, method, args);
        Object result = null;
        try {
            result = callable.call();
        }
        catch (Throwable ex) {
            this.adviceThrow(target, method, args, ex);
            throw ex;
        }
        finally {
            this.adviceAfter(target, method, args, result);
        }
        return result;
    }

    private void adviceBefore(TargetAdviceObject target, Method method, Object[] args) {
        try {
            for (Map.Entry<String, Collection<InstanceMethodAdvice>> entry : this.advices.entrySet()) {
                for (InstanceMethodAdvice each : entry.getValue()) {
                    if (!this.isPluginEnabled(each)) continue;
                    each.beforeMethod(target, new TargetAdviceMethod(method.getName()), args, entry.getKey());
                }
            }
        }
        catch (Throwable ex) {
            LOGGER.log(Level.SEVERE, "Failed to execute the pre-method of method `{0}` in class `{1}`, {2}.", new String[]{method.getName(), target.getClass().getName(), ex.getMessage()});
        }
    }

    private void adviceThrow(TargetAdviceObject target, Method method, Object[] args, Throwable ex) {
        try {
            for (Map.Entry<String, Collection<InstanceMethodAdvice>> entry : this.advices.entrySet()) {
                for (InstanceMethodAdvice each : entry.getValue()) {
                    if (!this.isPluginEnabled(each)) continue;
                    each.onThrowing(target, new TargetAdviceMethod(method.getName()), args, ex, entry.getKey());
                }
            }
        }
        catch (Throwable ignored) {
            LOGGER.log(Level.SEVERE, "Failed to execute the error handler of method `{0}` in class `{1}`, {2}.", new String[]{method.getName(), target.getClass().getName(), ex.getMessage()});
        }
    }

    private void adviceAfter(TargetAdviceObject target, Method method, Object[] args, Object result) {
        try {
            for (Map.Entry<String, Collection<InstanceMethodAdvice>> entry : this.advices.entrySet()) {
                for (InstanceMethodAdvice each : entry.getValue()) {
                    if (!this.isPluginEnabled(each)) continue;
                    each.afterMethod(target, new TargetAdviceMethod(method.getName()), args, result, entry.getKey());
                }
            }
        }
        catch (Throwable ex) {
            LOGGER.log(Level.SEVERE, "Failed to execute the post-method of method `{0}` in class `{1}`, {2}.", new String[]{method.getName(), target.getClass().getName(), ex.getMessage()});
        }
    }

    private boolean isPluginEnabled(InstanceMethodAdvice advice) {
        return !(advice instanceof AgentPluginEnable) || ((AgentPluginEnable)((Object)advice)).isPluginEnabled();
    }

    @Override
    public DynamicType.Builder<?> intercept(DynamicType.Builder<?> builder, MethodDescription pointcut) {
        return builder.method(ElementMatchers.is(pointcut)).intercept(MethodDelegation.withDefaultConfiguration().to(this));
    }

    @Generated
    public InstanceMethodAdviceExecutor(Map<String, Collection<InstanceMethodAdvice>> advices) {
        this.advices = advices;
    }
}

