/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.algorithm.shadow.column;

import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.algorithm.core.ShardingSphereAlgorithm;
import org.apache.shardingsphere.infra.algorithm.core.exception.AlgorithmInitializationException;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.shadow.algorithm.shadow.column.ColumnShadowValueValidator;
import org.apache.shardingsphere.shadow.spi.ShadowOperationType;
import org.apache.shardingsphere.shadow.spi.column.ColumnShadowAlgorithm;
import org.apache.shardingsphere.shadow.spi.column.PreciseColumnShadowValue;

public abstract class AbstractColumnMatchedShadowAlgorithm
implements ColumnShadowAlgorithm<Comparable<?>> {
    private static final String COLUMN_PROPS_KEY = "column";
    private static final String OPERATION_PROPS_KEY = "operation";
    private String shadowColumn;
    private ShadowOperationType shadowOperationType;

    public void init(Properties props) {
        this.shadowColumn = this.getShadowColumn(props);
        this.shadowOperationType = this.getShadowOperationType(props);
    }

    private String getShadowColumn(Properties props) {
        String result = props.getProperty(COLUMN_PROPS_KEY);
        ShardingSpherePreconditions.checkNotNull((Object)result, () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)this, "Column shadow algorithm column cannot be null", new Object[0]));
        return result;
    }

    private ShadowOperationType getShadowOperationType(Properties props) {
        String operationType = props.getProperty(OPERATION_PROPS_KEY);
        ShardingSpherePreconditions.checkNotNull((Object)operationType, () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)this, "Column shadow algorithm operation cannot be null", new Object[0]));
        Optional result = ShadowOperationType.valueFrom((String)operationType);
        ShardingSpherePreconditions.checkState((boolean)result.isPresent(), () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)this, "Column shadow algorithm operation must be one of [select, insert, update, delete]", new Object[0]));
        return (ShadowOperationType)result.get();
    }

    public final boolean isShadow(PreciseColumnShadowValue<Comparable<?>> shadowValue) {
        String table = shadowValue.getTableName();
        String column = shadowValue.getColumnName();
        Comparable value = shadowValue.getValue();
        if (this.shadowOperationType == shadowValue.getOperationType() && this.shadowColumn.equals(column)) {
            ColumnShadowValueValidator.validate(table, column, value);
            return this.matchesShadowValue(value);
        }
        return false;
    }

    protected abstract boolean matchesShadowValue(Comparable<?> var1);

    @Generated
    public String getShadowColumn() {
        return this.shadowColumn;
    }

    @Generated
    public ShadowOperationType getShadowOperationType() {
        return this.shadowOperationType;
    }
}

