/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.rule.changed;

import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mode.spi.rule.RuleItemConfigurationChangedProcessor;
import org.apache.shardingsphere.mode.spi.rule.item.alter.AlterNamedRuleItem;
import org.apache.shardingsphere.mode.spi.rule.item.alter.AlterRuleItem;
import org.apache.shardingsphere.mode.spi.rule.item.drop.DropNamedRuleItem;
import org.apache.shardingsphere.mode.spi.rule.item.drop.DropRuleItem;
import org.apache.shardingsphere.shadow.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.config.table.ShadowTableConfiguration;
import org.apache.shardingsphere.shadow.rule.ShadowRule;
import org.apache.shardingsphere.shadow.yaml.config.table.YamlShadowTableConfiguration;
import org.apache.shardingsphere.shadow.yaml.swapper.table.YamlShadowTableConfigurationSwapper;

public final class ShadowTableChangedProcessor
implements RuleItemConfigurationChangedProcessor<ShadowRuleConfiguration, ShadowTableConfiguration> {
    public ShadowTableConfiguration swapRuleItemConfiguration(AlterRuleItem alterRuleItem, String yamlContent) {
        return new YamlShadowTableConfigurationSwapper().swapToObject((YamlShadowTableConfiguration)YamlEngine.unmarshal((String)yamlContent, YamlShadowTableConfiguration.class));
    }

    public ShadowRuleConfiguration findRuleConfiguration(ShardingSphereDatabase database) {
        return database.getRuleMetaData().findSingleRule(ShadowRule.class).map(ShadowRule::getConfiguration).orElseGet(ShadowRuleConfiguration::new);
    }

    public void changeRuleItemConfiguration(AlterRuleItem alterRuleItem, ShadowRuleConfiguration currentRuleConfig, ShadowTableConfiguration toBeChangedItemConfig) {
        currentRuleConfig.getTables().put(((AlterNamedRuleItem)alterRuleItem).getItemName(), toBeChangedItemConfig);
    }

    public void dropRuleItemConfiguration(DropRuleItem dropRuleItem, ShadowRuleConfiguration currentRuleConfig) {
        currentRuleConfig.getTables().remove(((DropNamedRuleItem)dropRuleItem).getItemName());
    }

    public String getType() {
        return "shadow.tables";
    }
}

