/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.engine.database;

import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.engine.database.DatabaseRuleOperator;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.engine.database.type.AlterDatabaseRuleOperator;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.engine.database.type.CreateDatabaseRuleOperator;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.engine.database.type.DropDatabaseRuleOperator;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.DatabaseRuleAlterExecutor;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.DatabaseRuleCreateExecutor;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.DatabaseRuleDefinitionExecutor;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.DatabaseRuleDropExecutor;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.mode.manager.ContextManager;

public final class DatabaseRuleOperatorFactory {
    public static DatabaseRuleOperator newInstance(ContextManager contextManager, DatabaseRuleDefinitionExecutor executor) {
        if (executor instanceof DatabaseRuleCreateExecutor) {
            return new CreateDatabaseRuleOperator(contextManager, (DatabaseRuleCreateExecutor)executor);
        }
        if (executor instanceof DatabaseRuleAlterExecutor) {
            return new AlterDatabaseRuleOperator(contextManager, (DatabaseRuleAlterExecutor)executor);
        }
        if (executor instanceof DatabaseRuleDropExecutor) {
            return new DropDatabaseRuleOperator(contextManager, (DatabaseRuleDropExecutor)executor);
        }
        throw new UnsupportedSQLOperationException(String.format("Cannot support RDL executor type `%s`", executor.getClass().getName()));
    }

    @Generated
    private DatabaseRuleOperatorFactory() {
    }
}

