/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.mysql.command.query.binary.prepare;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLBinaryColumnType;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLCharacterSet;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLConstants;
import org.apache.shardingsphere.db.protocol.mysql.packet.MySQLPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.MySQLColumnDefinition41Packet;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.MySQLColumnDefinitionFlag;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.prepare.MySQLComStmtPrepareOKPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.prepare.MySQLComStmtPreparePacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.generic.MySQLEofPacket;
import org.apache.shardingsphere.db.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.binder.engine.SQLBindEngine;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.mysql.exception.TooManyPlaceholdersException;
import org.apache.shardingsphere.infra.exception.mysql.exception.UnsupportedPreparedStatementException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereColumn;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.session.ServerPreparedStatement;
import org.apache.shardingsphere.proxy.frontend.command.executor.CommandExecutor;
import org.apache.shardingsphere.proxy.frontend.mysql.command.ServerStatusFlagCalculator;
import org.apache.shardingsphere.proxy.frontend.mysql.command.query.binary.MySQLServerPreparedStatement;
import org.apache.shardingsphere.proxy.frontend.mysql.command.query.binary.MySQLStatementIdGenerator;
import org.apache.shardingsphere.proxy.frontend.mysql.command.query.binary.prepare.MySQLComStmtPrepareChecker;
import org.apache.shardingsphere.proxy.frontend.mysql.command.query.binary.prepare.MySQLComStmtPrepareParameterMarkerExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.statement.AbstractSQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;

public final class MySQLComStmtPrepareExecutor
implements CommandExecutor {
    private static final int MAX_PARAMETER_COUNT = 65535;
    private final MySQLComStmtPreparePacket packet;
    private final ConnectionSession connectionSession;

    public Collection<DatabasePacket> execute() {
        this.failedIfContainsMultiStatements();
        MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        SQLParserRule sqlParserRule = (SQLParserRule)metaDataContexts.getMetaData().getGlobalRuleMetaData().getSingleRule(SQLParserRule.class);
        DatabaseType databaseType = (DatabaseType)TypedSPILoader.getService(DatabaseType.class, (Object)"MySQL");
        SQLStatement sqlStatement = sqlParserRule.getSQLParserEngine(databaseType).parse(this.packet.getSQL(), true);
        if (!MySQLComStmtPrepareChecker.isAllowedStatement(sqlStatement)) {
            throw new UnsupportedPreparedStatementException();
        }
        SQLStatementContext sqlStatementContext = new SQLBindEngine(ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData(), this.connectionSession.getCurrentDatabaseName(), this.packet.getHintValueContext()).bind(sqlStatement, Collections.emptyList());
        int statementId = MySQLStatementIdGenerator.getInstance().nextStatementId(this.connectionSession.getConnectionId());
        MySQLServerPreparedStatement serverPreparedStatement = new MySQLServerPreparedStatement(this.packet.getSQL(), sqlStatementContext, this.packet.getHintValueContext(), new CopyOnWriteArrayList<Integer>());
        this.connectionSession.getServerPreparedStatementRegistry().addPreparedStatement((Object)statementId, (ServerPreparedStatement)serverPreparedStatement);
        return this.createPackets(sqlStatementContext, statementId, serverPreparedStatement);
    }

    private void failedIfContainsMultiStatements() {
        if (this.connectionSession.getAttributeMap().hasAttr(MySQLConstants.OPTION_MULTI_STATEMENTS_ATTRIBUTE_KEY) && 0 == (Integer)this.connectionSession.getAttributeMap().attr(MySQLConstants.OPTION_MULTI_STATEMENTS_ATTRIBUTE_KEY).get() && this.packet.getSQL().contains(";")) {
            throw new UnsupportedPreparedStatementException();
        }
    }

    private Collection<DatabasePacket> createPackets(SQLStatementContext sqlStatementContext, int statementId, MySQLServerPreparedStatement serverPreparedStatement) {
        LinkedList<DatabasePacket> result = new LinkedList<DatabasePacket>();
        Collection<Projection> projections = this.getProjections(sqlStatementContext);
        int parameterCount = sqlStatementContext.getSqlStatement().getParameterCount();
        ShardingSpherePreconditions.checkState((parameterCount <= 65535 ? 1 : 0) != 0, TooManyPlaceholdersException::new);
        result.add((DatabasePacket)new MySQLComStmtPrepareOKPacket(statementId, projections.size(), parameterCount, 0));
        int characterSet = ((MySQLCharacterSet)this.connectionSession.getAttributeMap().attr(MySQLConstants.CHARACTER_SET_ATTRIBUTE_KEY).get()).getId();
        int statusFlags = ServerStatusFlagCalculator.calculateFor(this.connectionSession, true);
        if (parameterCount > 0) {
            result.addAll(this.createParameterColumnDefinition41Packets(sqlStatementContext, characterSet, serverPreparedStatement));
            result.add((DatabasePacket)new MySQLEofPacket(statusFlags));
        }
        if (!projections.isEmpty() && sqlStatementContext instanceof SelectStatementContext) {
            result.addAll(this.createProjectionColumnDefinition41Packets((SelectStatementContext)sqlStatementContext, characterSet));
            result.add((DatabasePacket)new MySQLEofPacket(statusFlags));
        }
        return result;
    }

    private Collection<Projection> getProjections(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof SelectStatementContext ? ((SelectStatementContext)sqlStatementContext).getProjectionsContext().getExpandProjections() : Collections.emptyList();
    }

    private Collection<MySQLPacket> createParameterColumnDefinition41Packets(SQLStatementContext sqlStatementContext, int characterSet, MySQLServerPreparedStatement serverPreparedStatement) {
        List<ShardingSphereColumn> columnsOfParameterMarkers = MySQLComStmtPrepareParameterMarkerExtractor.findColumnsOfParameterMarkers(sqlStatementContext.getSqlStatement(), this.getSchema(sqlStatementContext));
        Collection parameterMarkerSegments = ((AbstractSQLStatement)sqlStatementContext.getSqlStatement()).getParameterMarkerSegments();
        ArrayList<MySQLPacket> result = new ArrayList<MySQLPacket>(parameterMarkerSegments.size());
        ArrayList<Integer> paramColumnDefinitionFlags = new ArrayList<Integer>(parameterMarkerSegments.size());
        for (int index = 0; index < parameterMarkerSegments.size(); ++index) {
            ShardingSphereColumn column = null;
            if (!columnsOfParameterMarkers.isEmpty() && index < columnsOfParameterMarkers.size()) {
                column = columnsOfParameterMarkers.get(index);
            }
            if (null != column) {
                int columnDefinitionFlag = this.calculateColumnDefinitionFlag(column);
                result.add((MySQLPacket)this.createMySQLColumnDefinition41Packet(characterSet, columnDefinitionFlag, MySQLBinaryColumnType.valueOfJDBCType((int)column.getDataType())));
                paramColumnDefinitionFlags.add(columnDefinitionFlag);
                continue;
            }
            result.add((MySQLPacket)this.createMySQLColumnDefinition41Packet(characterSet, 0, MySQLBinaryColumnType.VAR_STRING));
            paramColumnDefinitionFlags.add(0);
        }
        serverPreparedStatement.getParameterColumnDefinitionFlags().addAll(paramColumnDefinitionFlags);
        return result;
    }

    private Collection<MySQLPacket> createProjectionColumnDefinition41Packets(SelectStatementContext selectStatementContext, int characterSet) {
        List projections = selectStatementContext.getProjectionsContext().getExpandProjections();
        ShardingSphereSchema schema = this.getSchema((SQLStatementContext)selectStatementContext);
        ArrayList<MySQLPacket> result = new ArrayList<MySQLPacket>(projections.size());
        for (Projection each : projections) {
            if (each instanceof ColumnProjection) {
                result.add((MySQLPacket)Optional.ofNullable(schema.getTable(((ColumnProjection)each).getOriginalTable().getValue())).map(table -> table.getColumn(((ColumnProjection)each).getOriginalColumn().getValue())).map(column -> this.createMySQLColumnDefinition41Packet(characterSet, this.calculateColumnDefinitionFlag((ShardingSphereColumn)column), MySQLBinaryColumnType.valueOfJDBCType((int)column.getDataType()))).orElseGet(() -> this.createMySQLColumnDefinition41Packet(characterSet, 0, MySQLBinaryColumnType.VAR_STRING)));
                continue;
            }
            result.add((MySQLPacket)this.createMySQLColumnDefinition41Packet(characterSet, 0, MySQLBinaryColumnType.VAR_STRING));
        }
        return result;
    }

    private ShardingSphereSchema getSchema(SQLStatementContext sqlStatementContext) {
        String databaseName = ((TableAvailable)sqlStatementContext).getTablesContext().getDatabaseName().orElseGet(() -> ((ConnectionSession)this.connectionSession).getCurrentDatabaseName());
        ShardingSphereDatabase database = ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getDatabase(databaseName);
        return ((TableAvailable)sqlStatementContext).getTablesContext().getSchemaName().map(arg_0 -> ((ShardingSphereDatabase)database).getSchema(arg_0)).orElseGet(() -> database.getSchema(new DatabaseTypeRegistry(sqlStatementContext.getDatabaseType()).getDefaultSchemaName(database.getName())));
    }

    private int calculateColumnDefinitionFlag(ShardingSphereColumn column) {
        int result = 0;
        result |= column.isPrimaryKey() ? MySQLColumnDefinitionFlag.PRIMARY_KEY.getValue() : 0;
        return result |= column.isUnsigned() ? MySQLColumnDefinitionFlag.UNSIGNED.getValue() : 0;
    }

    private MySQLColumnDefinition41Packet createMySQLColumnDefinition41Packet(int characterSet, int columnDefinitionFlag, MySQLBinaryColumnType columnType) {
        return new MySQLColumnDefinition41Packet(characterSet, columnDefinitionFlag, "", "", "", "", "", 0, columnType, 0, false);
    }

    @Generated
    public MySQLComStmtPrepareExecutor(MySQLComStmtPreparePacket packet, ConnectionSession connectionSession) {
        this.packet = packet;
        this.connectionSession = connectionSession;
    }
}

