/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.tags;

import jakarta.servlet.jsp.JspException;
import org.apache.shiro.web.tags.SecureTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuestTag
extends SecureTag {
    private static final Logger log = LoggerFactory.getLogger(GuestTag.class);

    @Override
    public int onDoStartTag() throws JspException {
        if (this.getSubject() == null || this.getSubject().getPrincipal() == null) {
            if (log.isTraceEnabled()) {
                log.trace("Subject does not exist or does not have a known identity (aka 'principal').  Tag body will be evaluated.");
            }
            return 1;
        }
        if (log.isTraceEnabled()) {
            log.trace("Subject exists or has a known identity (aka 'principal').  Tag body will not be evaluated.");
        }
        return 0;
    }
}

