/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.entity;

import java.sql.Timestamp;
import java.util.Objects;
import java.util.Optional;
import org.apache.shenyu.admin.model.dto.ProxySelectorAddDTO;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.common.dto.ProxySelectorData;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.JsonUtils;
import org.apache.shenyu.common.utils.UUIDUtils;
import org.springframework.util.StringUtils;

public class ProxySelectorDO
extends BaseDO {
    private static final long serialVersionUID = 6324671206584485506L;
    private String name;
    private String pluginName;
    private String type;
    private Integer forwardPort;
    private String props;
    private String namespaceId;

    public static ProxySelectorBuilder builder() {
        return new ProxySelectorBuilder();
    }

    public static ProxySelectorDO buildProxySelectorDO(ProxySelectorAddDTO proxySelectorDTO) {
        return Optional.ofNullable(proxySelectorDTO).map(item -> {
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            ProxySelectorDO proxySelectorDO = ProxySelectorDO.builder().name(item.getName()).pluginName(PluginEnum.TCP.getName()).forwardPort(item.getForwardPort()).type(item.getType()).props(item.getProps()).namespaceId(item.getNamespaceId()).dateUpdated(currentTime).build();
            if (StringUtils.hasLength((String)item.getId())) {
                proxySelectorDO.setId(item.getId());
            } else {
                proxySelectorDO.setId(UUIDUtils.getInstance().generateShortUuid());
                proxySelectorDO.setDateCreated(currentTime);
            }
            return proxySelectorDO;
        }).orElse(null);
    }

    public static ProxySelectorDO buildProxySelectorDO(ProxySelectorData proxySelectorData) {
        return Optional.ofNullable(proxySelectorData).map(item -> {
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            ProxySelectorDO proxySelectorDO = ProxySelectorDO.builder().name(item.getName()).pluginName(PluginEnum.TCP.getName()).forwardPort(item.getForwardPort()).type(item.getType()).props(JsonUtils.toJson((Object)item.getProps())).dateUpdated(currentTime).build();
            if (StringUtils.hasLength((String)item.getId())) {
                proxySelectorDO.setId(item.getId());
            } else {
                proxySelectorDO.setId(UUIDUtils.getInstance().generateShortUuid());
                proxySelectorDO.setDateCreated(currentTime);
            }
            if (Objects.isNull(proxySelectorDO.getDateCreated())) {
                proxySelectorDO.setDateCreated(currentTime);
            }
            if (Objects.isNull(proxySelectorDO.getDateUpdated())) {
                proxySelectorDO.setDateUpdated(currentTime);
            }
            return proxySelectorDO;
        }).orElse(null);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Integer getForwardPort() {
        return this.forwardPort;
    }

    public void setForwardPort(Integer forwardPort) {
        this.forwardPort = forwardPort;
    }

    public String getProps() {
        return this.props;
    }

    public void setProps(String props) {
        this.props = props;
    }

    public String getNamespaceId() {
        return this.namespaceId;
    }

    public void setNamespaceId(String namespaceId) {
        this.namespaceId = namespaceId;
    }

    public static final class ProxySelectorBuilder {
        private String id;
        private Timestamp dateCreated;
        private Timestamp dateUpdated;
        private String name;
        private String pluginName;
        private String type;
        private Integer forwardPort;
        private String props;
        private String namespaceId;

        public ProxySelectorBuilder id(String id) {
            this.id = id;
            return this;
        }

        public ProxySelectorBuilder dateCreated(Timestamp dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public ProxySelectorBuilder dateUpdated(Timestamp dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public ProxySelectorBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ProxySelectorBuilder pluginName(String pluginName) {
            this.pluginName = pluginName;
            return this;
        }

        public ProxySelectorBuilder type(String type) {
            this.type = type;
            return this;
        }

        public ProxySelectorBuilder forwardPort(Integer forwardPort) {
            this.forwardPort = forwardPort;
            return this;
        }

        public ProxySelectorBuilder props(String props) {
            this.props = props;
            return this;
        }

        public ProxySelectorBuilder namespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }

        public ProxySelectorDO build() {
            ProxySelectorDO proxySelectorDO = new ProxySelectorDO();
            proxySelectorDO.setId(this.id);
            proxySelectorDO.setName(this.name);
            proxySelectorDO.setPluginName(this.pluginName);
            proxySelectorDO.setForwardPort(this.forwardPort);
            proxySelectorDO.setType(this.type);
            proxySelectorDO.setProps(this.props);
            proxySelectorDO.setNamespaceId(this.namespaceId);
            proxySelectorDO.setDateCreated(this.dateCreated);
            proxySelectorDO.setDateUpdated(this.dateUpdated);
            return proxySelectorDO;
        }
    }
}

