/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.aspect.annotation.DataPermission;
import org.apache.shenyu.admin.aspect.annotation.Pageable;
import org.apache.shenyu.admin.mapper.PluginMapper;
import org.apache.shenyu.admin.mapper.RuleConditionMapper;
import org.apache.shenyu.admin.mapper.RuleMapper;
import org.apache.shenyu.admin.mapper.SelectorMapper;
import org.apache.shenyu.admin.model.dto.RuleConditionDTO;
import org.apache.shenyu.admin.model.dto.RuleDTO;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.admin.model.entity.PluginDO;
import org.apache.shenyu.admin.model.entity.RuleConditionDO;
import org.apache.shenyu.admin.model.entity.RuleDO;
import org.apache.shenyu.admin.model.entity.SelectorDO;
import org.apache.shenyu.admin.model.event.rule.RuleCreatedEvent;
import org.apache.shenyu.admin.model.event.selector.BatchSelectorDeletedEvent;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageResultUtils;
import org.apache.shenyu.admin.model.query.RuleConditionQuery;
import org.apache.shenyu.admin.model.query.RuleQuery;
import org.apache.shenyu.admin.model.query.RuleQueryCondition;
import org.apache.shenyu.admin.model.result.ConfigImportResult;
import org.apache.shenyu.admin.model.vo.RuleConditionVO;
import org.apache.shenyu.admin.model.vo.RuleVO;
import org.apache.shenyu.admin.service.RuleService;
import org.apache.shenyu.admin.service.configs.ConfigsImportContext;
import org.apache.shenyu.admin.service.publish.RuleEventPublisher;
import org.apache.shenyu.admin.transfer.ConditionTransfer;
import org.apache.shenyu.admin.utils.Assert;
import org.apache.shenyu.admin.utils.SessionUtil;
import org.apache.shenyu.common.dto.ConditionData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.enums.MatchModeEnum;
import org.apache.shenyu.common.utils.JsonUtils;
import org.apache.shenyu.common.utils.ListUtil;
import org.apache.shenyu.common.utils.UUIDUtils;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RuleServiceImpl
implements RuleService {
    private final RuleMapper ruleMapper;
    private final RuleConditionMapper ruleConditionMapper;
    private final SelectorMapper selectorMapper;
    private final PluginMapper pluginMapper;
    private final RuleEventPublisher ruleEventPublisher;

    public RuleServiceImpl(RuleMapper ruleMapper, RuleConditionMapper ruleConditionMapper, SelectorMapper selectorMapper, PluginMapper pluginMapper, RuleEventPublisher ruleEventPublisher) {
        this.ruleMapper = ruleMapper;
        this.ruleConditionMapper = ruleConditionMapper;
        this.selectorMapper = selectorMapper;
        this.pluginMapper = pluginMapper;
        this.ruleEventPublisher = ruleEventPublisher;
    }

    @Override
    public void doConditionPreProcessing(RuleQueryCondition condition) {
        if (SessionUtil.isAdmin()) {
            condition.setUserId(null);
        }
    }

    @Override
    public List<RuleVO> searchByCondition(RuleQueryCondition condition) {
        condition.init();
        List<RuleVO> rules = this.ruleMapper.selectByCondition(condition);
        for (RuleVO rule : rules) {
            rule.setMatchModeName(MatchModeEnum.getMatchModeByCode((int)rule.getMatchMode()));
        }
        return rules;
    }

    @Override
    public String registerDefault(RuleDTO ruleDTO) {
        if (Objects.nonNull(this.ruleMapper.findBySelectorIdAndName(ruleDTO.getSelectorId(), ruleDTO.getName()))) {
            return "";
        }
        RuleDO ruleDO = RuleDO.buildRuleDO(ruleDTO);
        if (StringUtils.isEmpty((CharSequence)ruleDTO.getId())) {
            this.ruleMapper.insertSelective(ruleDO);
            this.addCondition(ruleDO, ruleDTO.getRuleConditions());
        }
        this.ruleEventPublisher.onRegister(ruleDO, ruleDTO.getRuleConditions());
        this.ruleEventPublisher.publish(new RuleCreatedEvent(ruleDO, ruleDTO.getNamespaceId()));
        return ruleDO.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int createOrUpdate(RuleDTO ruleDTO) {
        return RuleService.super.createOrUpdate(ruleDTO);
    }

    @Override
    public int create(RuleDTO ruleDTO) {
        RuleDO ruleDO = RuleDO.buildRuleDO(ruleDTO);
        int ruleCount = this.ruleMapper.insertSelective(ruleDO);
        this.addCondition(ruleDO, ruleDTO.getRuleConditions());
        if (ruleCount > 0) {
            this.ruleEventPublisher.onCreated(ruleDO, ruleDTO.getRuleConditions());
        }
        return ruleCount;
    }

    @Override
    public int update(RuleDTO ruleDTO) {
        RuleDO before = this.ruleMapper.selectById(ruleDTO.getId());
        Assert.notNull(before, "the updated rule is not found");
        RuleDO ruleDO = RuleDO.buildRuleDO(ruleDTO);
        int ruleCount = this.ruleMapper.updateSelective(ruleDO);
        List<RuleConditionDO> beforeRuleCondition = this.ruleConditionMapper.selectByQuery(new RuleConditionQuery(ruleDO.getId()));
        List beforeCondition = beforeRuleCondition.stream().map(ruleConditionDO -> RuleConditionDTO.builder().ruleId(ruleConditionDO.getRuleId()).operator(ruleConditionDO.getOperator()).paramName(ruleConditionDO.getParamName()).paramType(ruleConditionDO.getParamType()).paramValue(ruleConditionDO.getParamValue()).build()).collect(Collectors.toList());
        List currentCondition = ruleDTO.getRuleConditions().stream().map(ruleConditionDTO -> RuleConditionDTO.builder().ruleId(ruleConditionDTO.getRuleId()).operator(ruleConditionDTO.getOperator()).paramName(ruleConditionDTO.getParamName()).paramType(ruleConditionDTO.getParamType()).paramValue(ruleConditionDTO.getParamValue()).build()).collect(Collectors.toList());
        if (CollectionUtils.isEqualCollection(beforeCondition, currentCondition)) {
            beforeRuleCondition = Collections.emptyList();
        }
        this.ruleConditionMapper.deleteByQuery(new RuleConditionQuery(ruleDO.getId()));
        this.addCondition(ruleDO, ruleDTO.getRuleConditions());
        if (ruleCount > 0) {
            this.ruleEventPublisher.onUpdated(ruleDO, before, ruleDTO.getRuleConditions(), beforeRuleCondition);
        }
        return ruleCount;
    }

    @Override
    public RuleVO findById(String id) {
        return RuleVO.buildRuleVO(this.ruleMapper.selectById(id), ListUtil.map(this.ruleConditionMapper.selectByQuery(new RuleConditionQuery(id)), RuleConditionVO::buildRuleConditionVO));
    }

    @Override
    @DataPermission(dataType="rule")
    @Pageable
    public CommonPager<RuleVO> listByPage(RuleQuery ruleQuery) {
        return PageResultUtils.result(ruleQuery.getPageParameter(), () -> ListUtil.map(this.ruleMapper.selectByQuery(ruleQuery), RuleVO::buildRuleVO));
    }

    @Override
    public List<RuleData> listAll() {
        return this.buildRuleDataList(this.ruleMapper.selectAll());
    }

    @Override
    public List<RuleData> listAllByNamespaceId(String namespaceId) {
        return this.buildRuleDataList(this.ruleMapper.selectAllByNamespaceId(namespaceId));
    }

    @Override
    public List<RuleVO> listAllData() {
        return this.buildRuleVOList(this.ruleMapper.selectAll());
    }

    @Override
    public List<RuleVO> listAllDataByNamespaceId(String namespaceId) {
        return this.buildRuleVOList(this.ruleMapper.selectAllByNamespaceId(namespaceId));
    }

    @Override
    public List<RuleData> findBySelectorId(String selectorId) {
        return this.buildRuleDataList(this.ruleMapper.findBySelectorId(selectorId));
    }

    @Override
    public List<RuleData> findBySelectorIdList(List<String> selectorIdList) {
        return this.buildRuleDataList(this.ruleMapper.findBySelectorIds(selectorIdList));
    }

    @Override
    public RuleDO findByName(String name) {
        return this.ruleMapper.findByName(name);
    }

    @Override
    public RuleDO findBySelectorIdAndName(String selectorId, String name) {
        return this.ruleMapper.findBySelectorIdAndName(selectorId, name);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ConfigImportResult importData(List<RuleDTO> ruleList) {
        if (CollectionUtils.isEmpty(ruleList)) {
            return ConfigImportResult.success();
        }
        Map<String, List<RuleDO>> selectorRuleMap = this.ruleMapper.selectAll().stream().collect(Collectors.groupingBy(RuleDO::getSelectorId));
        int successCount = 0;
        StringBuilder errorMsgBuilder = new StringBuilder();
        for (RuleDTO ruleDTO : ruleList) {
            String selectorId = ruleDTO.getSelectorId();
            String ruleName = ruleDTO.getName();
            Set existRuleNameSet = selectorRuleMap.getOrDefault(selectorId, Lists.newArrayList()).stream().map(RuleDO::getName).collect(Collectors.toSet());
            if (existRuleNameSet.contains(ruleName)) {
                errorMsgBuilder.append(ruleName).append(",");
                continue;
            }
            RuleDO ruleDO = RuleDO.buildRuleDO(ruleDTO);
            int ruleCount = this.ruleMapper.insertSelective(ruleDO);
            this.addCondition(ruleDO, ruleDTO.getRuleConditions());
            if (ruleCount <= 0) continue;
            ++successCount;
        }
        if (StringUtils.isNotEmpty((CharSequence)errorMsgBuilder)) {
            errorMsgBuilder.setLength(errorMsgBuilder.length() - 1);
            return ConfigImportResult.fail(successCount, "import fail rule: " + errorMsgBuilder);
        }
        return ConfigImportResult.success(successCount);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ConfigImportResult importData(String namespace, List<RuleDTO> ruleList, ConfigsImportContext context) {
        if (CollectionUtils.isEmpty(ruleList)) {
            return ConfigImportResult.success();
        }
        Map<String, String> selectorIdMapping = context.getSelectorIdMapping();
        Map<String, List<RuleDO>> selectorRuleMap = this.ruleMapper.selectAllByNamespaceId(namespace).stream().collect(Collectors.groupingBy(RuleDO::getSelectorId));
        int successCount = 0;
        StringBuilder errorMsgBuilder = new StringBuilder();
        for (RuleDTO ruleDTO : ruleList) {
            String selectorId = ruleDTO.getSelectorId();
            String ruleName = ruleDTO.getName();
            String newSelectorId = selectorIdMapping.get(selectorId);
            if (Objects.isNull(newSelectorId)) {
                errorMsgBuilder.append(ruleName).append(",");
                continue;
            }
            Set existRuleNameSet = selectorRuleMap.getOrDefault(newSelectorId, Lists.newArrayList()).stream().map(RuleDO::getName).collect(Collectors.toSet());
            if (existRuleNameSet.contains(ruleName)) {
                errorMsgBuilder.append(ruleName).append(",");
                continue;
            }
            ruleDTO.setNamespaceId(namespace);
            ruleDTO.setSelectorId(newSelectorId);
            String ruleId = UUIDUtils.getInstance().generateShortUuid();
            ruleDTO.setId(ruleId);
            RuleDO ruleDO = RuleDO.buildRuleDO(ruleDTO);
            int ruleCount = this.ruleMapper.insertSelective(ruleDO);
            Optional.ofNullable(ruleDTO.getRuleConditions()).orElse(Collections.emptyList()).forEach(c -> {
                c.setRuleId(ruleId);
                c.setId(null);
            });
            this.addCondition(ruleDO, ruleDTO.getRuleConditions());
            if (ruleCount <= 0) continue;
            ++successCount;
        }
        if (StringUtils.isNotEmpty((CharSequence)errorMsgBuilder)) {
            errorMsgBuilder.setLength(errorMsgBuilder.length() - 1);
            return ConfigImportResult.fail(successCount, "import fail rule: " + errorMsgBuilder);
        }
        return ConfigImportResult.success(successCount);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean enabledByIdsAndNamespaceId(List<String> ids, Boolean enabled, String namespaceId) {
        ids.forEach(id -> {
            RuleDO ruleDO = this.ruleMapper.selectById((String)id);
            RuleDO before = (RuleDO)JsonUtils.jsonToObject((String)JsonUtils.toJson((Object)ruleDO), RuleDO.class);
            ruleDO.setEnabled(enabled);
            if (this.ruleMapper.updateEnable((String)id, enabled) > 0) {
                List<RuleConditionDO> conditionList = this.ruleConditionMapper.selectByQuery(new RuleConditionQuery(ruleDO.getId()));
                List<RuleConditionDTO> conditions = conditionList.stream().map(item -> RuleConditionDTO.builder().ruleId(item.getRuleId()).id(item.getId()).operator(item.getOperator()).paramName(item.getParamName()).paramValue(item.getParamValue()).paramType(item.getParamType()).build()).toList();
                this.ruleEventPublisher.onUpdated(ruleDO, before, conditions, Collections.emptyList());
            }
        });
        return Boolean.TRUE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int deleteByIdsAndNamespaceId(List<String> ids, String namespaceId) {
        List<RuleDO> rules = this.ruleMapper.selectByIds(ids);
        int deleteCount = this.ruleMapper.deleteByIds(ids);
        if (deleteCount > 0) {
            this.ruleEventPublisher.onDeleted((Collection<RuleDO>)rules);
            this.ruleConditionMapper.deleteByRuleIds(ids);
        }
        return deleteCount;
    }

    @EventListener(value={BatchSelectorDeletedEvent.class})
    public void onSelectorDeleted(BatchSelectorDeletedEvent event) {
        List<RuleDO> ruleDOList = this.ruleMapper.findBySelectorIds(event.getDeletedIds());
        List ruleIds = ListUtil.map(ruleDOList, BaseDO::getId);
        if (CollectionUtils.isNotEmpty(ruleDOList)) {
            int deleteCount = this.ruleMapper.deleteByIds(ruleIds);
            this.ruleConditionMapper.deleteByRuleIds(ruleIds);
            if (deleteCount > 0) {
                this.ruleEventPublisher.onDeleted(ruleDOList, event);
            }
        }
    }

    private void addCondition(RuleDO ruleDO, List<RuleConditionDTO> ruleConditions) {
        for (RuleConditionDTO ruleCondition : ruleConditions) {
            ruleCondition.setRuleId(ruleDO.getId());
            this.ruleConditionMapper.insertSelective(RuleConditionDO.buildRuleConditionDO(ruleCondition));
        }
    }

    private List<RuleData> buildRuleDataList(List<RuleDO> ruleDOList) {
        if (CollectionUtils.isEmpty(ruleDOList)) {
            return new ArrayList<RuleData>();
        }
        Map<String, String> ruleDOMap = ruleDOList.stream().filter(Objects::nonNull).collect(Collectors.toMap(BaseDO::getId, RuleDO::getSelectorId, (selectorId1, selectorId2) -> selectorId1));
        Map<String, String> pluginIdMap = Optional.ofNullable(this.selectorMapper.selectByIdSet(new HashSet<String>(ruleDOMap.values()))).orElseGet(ArrayList::new).stream().filter(Objects::nonNull).collect(Collectors.toMap(BaseDO::getId, SelectorDO::getPluginId, (value1, value2) -> value1));
        Map pluginDOMap = Optional.ofNullable(this.pluginMapper.selectByIds(new ArrayList<String>(pluginIdMap.values()))).orElseGet(ArrayList::new).stream().filter(Objects::nonNull).collect(Collectors.toMap(BaseDO::getId, Function.identity(), (value1, value2) -> value1));
        Map<String, List> conditionMap = Optional.ofNullable(this.ruleConditionMapper.selectByRuleIdSet(ruleDOMap.keySet())).orElseGet(ArrayList::new).stream().filter(Objects::nonNull).collect(Collectors.toMap(RuleConditionDO::getRuleId, ruleConditionDO -> ListUtil.list((Object[])new ConditionData[]{ConditionTransfer.INSTANCE.mapToRuleDO((RuleConditionDO)ruleConditionDO)}), ListUtil::merge));
        return ruleDOList.stream().filter(Objects::nonNull).map(ruleDO -> {
            PluginDO pluginDO;
            String selectorId;
            String pluginId;
            String ruleId = ruleDO.getId();
            List conditions = (List)conditionMap.get(ruleId);
            if (CollectionUtils.isNotEmpty((Collection)conditions) && StringUtils.isNotEmpty((CharSequence)(pluginId = (String)pluginIdMap.get(selectorId = ruleDO.getSelectorId()))) && Objects.nonNull(pluginDO = (PluginDO)pluginDOMap.get(pluginId))) {
                return RuleDO.transFrom(ruleDO, pluginDO.getName(), conditions);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<RuleVO> buildRuleVOList(List<RuleDO> ruleDOList) {
        if (CollectionUtils.isEmpty(ruleDOList)) {
            return new ArrayList<RuleVO>();
        }
        Map<String, String> ruleDOMap = ruleDOList.stream().filter(Objects::nonNull).collect(Collectors.toMap(BaseDO::getId, RuleDO::getSelectorId, (selectorId1, selectorId2) -> selectorId1));
        Map<String, String> pluginIdMap = Optional.ofNullable(this.selectorMapper.selectByIdSet(new HashSet<String>(ruleDOMap.values()))).orElseGet(ArrayList::new).stream().filter(Objects::nonNull).collect(Collectors.toMap(BaseDO::getId, SelectorDO::getPluginId, (value1, value2) -> value1));
        Map pluginDOMap = Optional.ofNullable(this.pluginMapper.selectByIds(new ArrayList<String>(pluginIdMap.values()))).orElseGet(ArrayList::new).stream().filter(Objects::nonNull).collect(Collectors.toMap(BaseDO::getId, Function.identity(), (value1, value2) -> value1));
        Map<String, List> conditionMap = Optional.ofNullable(this.ruleConditionMapper.selectByRuleIdSet(ruleDOMap.keySet())).orElseGet(ArrayList::new).stream().filter(Objects::nonNull).collect(Collectors.toMap(RuleConditionDO::getRuleId, ruleConditionDO -> ListUtil.list((Object[])new RuleConditionVO[]{RuleConditionVO.buildRuleConditionVO(ruleConditionDO)}), ListUtil::merge));
        return ruleDOList.stream().filter(Objects::nonNull).map(ruleDO -> {
            PluginDO pluginDO;
            String selectorId;
            String pluginId;
            String ruleId = ruleDO.getId();
            List conditions = (List)conditionMap.get(ruleId);
            if (CollectionUtils.isNotEmpty((Collection)conditions) && StringUtils.isNotEmpty((CharSequence)(pluginId = (String)pluginIdMap.get(selectorId = ruleDO.getSelectorId()))) && Objects.nonNull(pluginDO = (PluginDO)pluginDOMap.get(pluginId))) {
                return RuleVO.buildRuleVO(ruleDO, conditions);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

