/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.register;

import jakarta.annotation.Resource;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.listener.DataChangedEvent;
import org.apache.shenyu.admin.mapper.NamespacePluginRelMapper;
import org.apache.shenyu.admin.mapper.PluginMapper;
import org.apache.shenyu.admin.model.dto.DiscoveryUpstreamDTO;
import org.apache.shenyu.admin.model.dto.RuleConditionDTO;
import org.apache.shenyu.admin.model.dto.RuleDTO;
import org.apache.shenyu.admin.model.entity.PluginDO;
import org.apache.shenyu.admin.model.entity.SelectorDO;
import org.apache.shenyu.admin.model.vo.NamespacePluginVO;
import org.apache.shenyu.admin.service.DiscoveryService;
import org.apache.shenyu.admin.service.DiscoveryUpstreamService;
import org.apache.shenyu.admin.service.MetaDataService;
import org.apache.shenyu.admin.service.RuleService;
import org.apache.shenyu.admin.service.SelectorService;
import org.apache.shenyu.admin.service.impl.UpstreamCheckService;
import org.apache.shenyu.admin.service.manager.RegisterApiDocService;
import org.apache.shenyu.admin.service.register.FallbackShenyuClientRegisterService;
import org.apache.shenyu.admin.service.register.ShenyuClientRegisterService;
import org.apache.shenyu.admin.utils.CommonUpstreamUtils;
import org.apache.shenyu.common.dto.DiscoverySyncData;
import org.apache.shenyu.common.dto.DiscoveryUpstreamData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.selector.CommonUpstream;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.enums.MatchModeEnum;
import org.apache.shenyu.common.enums.OperatorEnum;
import org.apache.shenyu.common.enums.ParamTypeEnum;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.PathUtils;
import org.apache.shenyu.common.utils.PluginNameAdapter;
import org.apache.shenyu.register.common.dto.ApiDocRegisterDTO;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public abstract class AbstractShenyuClientRegisterServiceImpl
extends FallbackShenyuClientRegisterService
implements ShenyuClientRegisterService {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractShenyuClientRegisterServiceImpl.class);
    @Resource
    private ApplicationEventPublisher eventPublisher;
    @Resource
    private SelectorService selectorService;
    @Resource
    private MetaDataService metaDataService;
    @Resource
    private RuleService ruleService;
    @Resource
    private UpstreamCheckService upstreamCheckService;
    @Resource
    private RegisterApiDocService registerApiDocService;
    @Resource
    private DiscoveryService discoveryService;
    @Resource
    private DiscoveryUpstreamService discoveryUpstreamService;
    @Resource
    private PluginMapper pluginMapper;
    @Resource
    private NamespacePluginRelMapper namespacePluginRelMapper;

    protected abstract String selectorHandler(MetaDataRegisterDTO var1);

    protected abstract String ruleHandler();

    protected abstract void registerMetadata(MetaDataRegisterDTO var1);

    protected abstract String buildHandle(List<URIRegisterDTO> var1, SelectorDO var2);

    @Override
    public String register(MetaDataRegisterDTO dto) {
        String namespaceId = (String)StringUtils.defaultIfEmpty((CharSequence)dto.getNamespaceId(), (CharSequence)"649330b6-c2d7-4edc-be8e-8a54df9eb385");
        String pluginName = PluginNameAdapter.rpcTypeAdapter((String)this.rpcType());
        this.checkNamespacePluginRel(namespaceId, pluginName);
        dto.setNamespaceId(namespaceId);
        String selectorHandler = this.selectorHandler(dto);
        String selectorId = this.selectorService.registerDefault(dto, PluginNameAdapter.rpcTypeAdapter((String)this.rpcType()), selectorHandler);
        String ruleHandler = this.ruleHandler();
        RuleDTO ruleDTO = this.buildRpcDefaultRuleDTO(selectorId, dto, ruleHandler);
        this.ruleService.registerDefault(ruleDTO);
        this.registerMetadata(dto);
        String contextPath = dto.getContextPath();
        if (StringUtils.isNotEmpty((CharSequence)contextPath)) {
            this.registerContextPath(dto);
        }
        return "success";
    }

    @Override
    public String registerApiDoc(ApiDocRegisterDTO apiDocRegisterDTO) {
        this.registerApiDocService.registerApiDocument(apiDocRegisterDTO);
        return "success";
    }

    @Override
    public String doRegisterURI(String selectorName, List<URIRegisterDTO> uriList, String namespaceId) {
        if (CollectionUtils.isEmpty(uriList)) {
            return "";
        }
        String pluginName = PluginNameAdapter.rpcTypeAdapter((String)this.rpcType());
        SelectorDO selectorDO = this.selectorService.findByNameAndPluginNameAndNamespaceId(selectorName, pluginName, namespaceId);
        if (Objects.isNull(selectorDO)) {
            throw new ShenyuException("doRegister Failed to execute, wait to retry.");
        }
        this.checkNamespacePluginRel(namespaceId, pluginName);
        List<URIRegisterDTO> validUriList = uriList.stream().filter(dto -> Objects.nonNull(dto.getPort()) && StringUtils.isNotBlank((CharSequence)dto.getHost())).collect(Collectors.toList());
        String handler = this.buildHandle(validUriList, selectorDO);
        if (Objects.nonNull(handler)) {
            selectorDO.setHandle(handler);
            SelectorData selectorData = this.selectorService.buildByNameAndPluginNameAndNamespaceId(selectorName, PluginNameAdapter.rpcTypeAdapter((String)this.rpcType()), namespaceId);
            selectorData.setHandle(handler);
            this.selectorService.updateSelective(selectorDO);
            this.doDiscoveryLocal(selectorDO, pluginName, validUriList);
        }
        return "success";
    }

    @Override
    public void checkNamespacePluginRel(String namespaceId, String pluginName) {
        PluginDO pluginDO = this.pluginMapper.selectByName(pluginName);
        NamespacePluginVO namespacePluginRelation = this.namespacePluginRelMapper.selectByPluginIdAndNamespaceId(pluginDO.getId(), namespaceId);
        if (Objects.isNull(namespacePluginRelation)) {
            String errorMsg = String.format("%s plugin not enabled for current namespace or plugin not exist for namespaceId: %s", pluginName, namespaceId);
            throw new IllegalArgumentException(errorMsg);
        }
    }

    @Override
    public String doHeartbeat(String selectorName, List<URIRegisterDTO> uriList, String namespaceId) {
        if (CollectionUtils.isEmpty(uriList)) {
            return "";
        }
        String pluginName = PluginNameAdapter.rpcTypeAdapter((String)this.rpcType());
        SelectorDO selectorDO = this.selectorService.findByNameAndPluginNameAndNamespaceId(selectorName, pluginName, namespaceId);
        if (Objects.isNull(selectorDO)) {
            throw new ShenyuException("doHeartbeat Failed to execute,wait to retry.");
        }
        List<URIRegisterDTO> validUriList = uriList.stream().filter(dto -> Objects.nonNull(dto.getPort()) && StringUtils.isNotBlank((CharSequence)dto.getHost())).toList();
        if (CollectionUtils.isEmpty(validUriList)) {
            return null;
        }
        String selectorId = selectorDO.getId();
        validUriList.forEach(uriRegisterDTO -> {
            DiscoveryUpstreamDTO discoveryUpstreamDTO = CommonUpstreamUtils.buildDefaultDiscoveryUpstreamDTO(uriRegisterDTO.getHost(), uriRegisterDTO.getPort(), uriRegisterDTO.getProtocol(), uriRegisterDTO.getNamespaceId());
            LOG.info("change alive selectorId={}|url={}", (Object)selectorId, (Object)discoveryUpstreamDTO.getUrl());
            this.discoveryUpstreamService.changeStatusBySelectorIdAndUrl(selectorId, discoveryUpstreamDTO.getUrl(), Boolean.TRUE);
        });
        DiscoverySyncData discoverySyncData = this.fetch(selectorId, selectorDO.getName(), pluginName, namespaceId);
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.DISCOVER_UPSTREAM, DataEventTypeEnum.REFRESH, Collections.singletonList(discoverySyncData)));
        return "success";
    }

    protected void doDiscoveryLocal(SelectorDO selectorDO, String pluginName, List<URIRegisterDTO> uriList) {
        String discoveryHandlerId = this.discoveryService.registerDefaultDiscovery(selectorDO.getId(), pluginName, selectorDO.getNamespaceId());
        for (URIRegisterDTO uriRegisterDTO : uriList) {
            DiscoveryUpstreamDTO discoveryUpstreamDTO = CommonUpstreamUtils.buildDefaultDiscoveryUpstreamDTO(uriRegisterDTO.getHost(), uriRegisterDTO.getPort(), uriRegisterDTO.getProtocol(), selectorDO.getNamespaceId());
            discoveryUpstreamDTO.setDiscoveryHandlerId(discoveryHandlerId);
            this.discoveryUpstreamService.nativeCreateOrUpdate(discoveryUpstreamDTO);
        }
        DiscoverySyncData discoverySyncData = this.fetch(selectorDO.getId(), selectorDO.getName(), pluginName, selectorDO.getNamespaceId());
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.DISCOVER_UPSTREAM, DataEventTypeEnum.UPDATE, Collections.singletonList(discoverySyncData)));
    }

    protected DiscoverySyncData fetch(String selectorId, String selectorName, String pluginName, String namespaceId) {
        List<DiscoveryUpstreamData> discoveryUpstreamDataList = this.discoveryUpstreamService.findBySelectorId(selectorId);
        DiscoverySyncData discoverySyncData = new DiscoverySyncData();
        discoverySyncData.setUpstreamDataList(discoveryUpstreamDataList);
        discoverySyncData.setPluginName(pluginName);
        discoverySyncData.setSelectorId(selectorId);
        discoverySyncData.setSelectorName(selectorName);
        discoverySyncData.setNamespaceId(namespaceId);
        return discoverySyncData;
    }

    protected void removeDiscoveryUpstream(String selectorId, String url) {
        this.discoveryUpstreamService.deleteBySelectorIdAndUrl(selectorId, url);
    }

    public MetaDataService getMetaDataService() {
        return this.metaDataService;
    }

    public SelectorService getSelectorService() {
        return this.selectorService;
    }

    public RuleService getRuleService() {
        return this.ruleService;
    }

    public ApplicationEventPublisher getEventPublisher() {
        return this.eventPublisher;
    }

    protected boolean doSubmit(String selectorId, List<? extends CommonUpstream> upstreamList) {
        List<CommonUpstream> commonUpstreamList = CommonUpstreamUtils.convertCommonUpstreamList(upstreamList);
        if (CollectionUtils.isEmpty(upstreamList)) {
            return true;
        }
        return commonUpstreamList.stream().map(upstream -> this.upstreamCheckService.checkAndSubmit(selectorId, (CommonUpstream)upstream)).toList().stream().findAny().orElse(false);
    }

    protected RuleDTO buildContextPathDefaultRuleDTO(String selectorId, MetaDataRegisterDTO metaDataDTO, String ruleHandler) {
        String contextPath = metaDataDTO.getContextPath();
        String namespaceId = metaDataDTO.getNamespaceId();
        return this.buildRuleDTO(selectorId, ruleHandler, contextPath, PathUtils.decoratorPath((String)contextPath), namespaceId);
    }

    private RuleDTO buildRpcDefaultRuleDTO(String selectorId, MetaDataRegisterDTO metaDataDTO, String ruleHandler) {
        return this.buildRuleDTO(selectorId, ruleHandler, metaDataDTO.getRuleName(), metaDataDTO.getPath(), metaDataDTO.getNamespaceId());
    }

    private RuleDTO buildRuleDTO(String selectorId, String ruleHandler, String ruleName, String path, String namespaceId) {
        RuleDTO ruleDTO = RuleDTO.builder().selectorId(selectorId).name(ruleName).matchMode(MatchModeEnum.AND.getCode()).enabled(Boolean.TRUE).loged(Boolean.TRUE).matchRestful(Boolean.FALSE).sort(1).handle(ruleHandler).namespaceId(namespaceId).build();
        String conditionPath = this.rewritePath(path);
        RuleConditionDTO ruleConditionDTO = RuleConditionDTO.builder().paramType(ParamTypeEnum.URI.getName()).paramName("/").paramValue(conditionPath).build();
        if (conditionPath.endsWith("/")) {
            ruleConditionDTO.setOperator(OperatorEnum.STARTS_WITH.getAlias());
        } else if (conditionPath.endsWith("/**")) {
            ruleConditionDTO.setOperator(OperatorEnum.PATH_PATTERN.getAlias());
        } else if (conditionPath.indexOf("*") > 1) {
            ruleConditionDTO.setOperator(OperatorEnum.MATCH.getAlias());
        } else {
            ruleConditionDTO.setOperator(OperatorEnum.EQ.getAlias());
        }
        ruleDTO.setRuleConditions(Collections.singletonList(ruleConditionDTO));
        return ruleDTO;
    }

    private String rewritePath(String path) {
        if (path.contains("{")) {
            return path.replaceAll("(/\\{.*?})+", "/**");
        }
        return path;
    }
}

