/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.configuration.connector.localfile;

import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.PluginType;
import com.tencent.polaris.api.plugin.common.InitContext;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.configuration.ConfigFile;
import com.tencent.polaris.api.plugin.configuration.ConfigFileConnector;
import com.tencent.polaris.api.plugin.configuration.ConfigFileResponse;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.client.util.Utils;
import com.tencent.polaris.factory.util.FileUtils;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.configuration.connector.localfile.ConfigFileChange;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import shade.polaris.org.yaml.snakeyaml.Yaml;

public class LocalFileConfigFileConnector
implements ConfigFileConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalFileConfigFileConnector.class);
    private ExecutorService executorService;
    private WatchService watcher;
    private String persistDirPath;
    private Path dir;
    private BlockingQueue<ConfigFileChange> blockingQueue = new ArrayBlockingQueue<ConfigFileChange>(1024);
    private static final String CACHE_SUFFIX = ".yaml";

    @Override
    public void init(InitContext ctx) throws PolarisException {
        String dirPath = ctx.getConfig().getConfigFile().getServerConnector().getPersistDir();
        if (StringUtils.isBlank(dirPath)) {
            dirPath = "./polaris/backup/config";
        }
        this.persistDirPath = Utils.translatePath(dirPath);
        this.dir = Paths.get(this.persistDirPath, new String[0]);
        try {
            FileUtils.dirPathCheck(this.persistDirPath);
        }
        catch (IOException ex) {
            throw new PolarisException(ErrorCode.INVALID_CONFIG, ex.getMessage(), ex);
        }
        this.executorService = Executors.newSingleThreadExecutor();
        try {
            this.watcher = FileSystems.getDefault().newWatchService();
            this.dir.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            LOGGER.info("init local file config connector,watch dir:[{}].", (Object)this.persistDirPath);
        }
        catch (IOException e) {
            LOGGER.error("file system watch path: " + this.persistDirPath + " error.", (Throwable)e);
            throw new PolarisException(ErrorCode.UNKNOWN_SERVER_ERROR, "");
        }
        this.watchFileChange();
    }

    @Override
    public ConfigFileResponse getConfigFile(ConfigFile configFile) {
        String configFileName = LocalFileConfigFileConnector.configFileToFileName(configFile);
        ConfigFile configFileRes = this.loadConfigFile(configFileName);
        if (configFileRes != null) {
            return new ConfigFileResponse(200000, "success.", configFileRes);
        }
        return new ConfigFileResponse(400202, "config file not found.", null);
    }

    @Override
    public ConfigFileResponse watchConfigFiles(List<ConfigFile> configFiles) {
        try {
            ConfigFileChange configFileChange;
            Optional<ConfigFile> optional;
            do {
                configFileChange = this.blockingQueue.take();
            } while (!(optional = configFiles.stream().filter(item -> LocalFileConfigFileConnector.configFileToFileName(item).equals(configFileChange.getFileName())).findFirst()).isPresent());
            return this.getConfigFile(optional.get());
        }
        catch (InterruptedException e) {
            LOGGER.warn("config file watch interrupt " + e.getMessage());
            return null;
        }
    }

    @Override
    public ConfigFileResponse createConfigFile(ConfigFile configFile) {
        return null;
    }

    @Override
    public ConfigFileResponse updateConfigFile(ConfigFile configFile) {
        return null;
    }

    @Override
    public ConfigFileResponse releaseConfigFile(ConfigFile configFile) {
        return null;
    }

    @Override
    public String getName() {
        return "localFile";
    }

    @Override
    public PluginType getType() {
        return PluginTypes.CONFIG_FILE_CONNECTOR.getBaseType();
    }

    @Override
    public void postContextInit(Extensions extensions) throws PolarisException {
    }

    @Override
    public void destroy() {
        if (this.watcher != null) {
            try {
                this.watcher.close();
                LOGGER.info("watcher close success.");
            }
            catch (IOException e) {
                LOGGER.error("watcher close error.", (Throwable)e);
            }
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    private void watchFileChange() {
        this.executorService.execute(() -> {
            while (true) {
                WatchKey key = null;
                try {
                    key = this.watcher.take();
                }
                catch (InterruptedException e) {
                    LOGGER.error("file watcher take interrupted.", (Throwable)e);
                }
                catch (ClosedWatchServiceException e) {
                    LOGGER.warn("file watcher closed.", (Throwable)e);
                    return;
                }
                List<WatchEvent<?>> watchEvents = key.pollEvents();
                for (WatchEvent<?> event : watchEvents) {
                    LOGGER.info("watched file event:{}:{}/{}.", new Object[]{event.kind(), this.dir.toAbsolutePath(), event.context()});
                    if (StandardWatchEventKinds.ENTRY_CREATE == event.kind()) {
                        this.blockingQueue.offer(new ConfigFileChange(ConfigFileChange.ChangeType.CREATE, event.context().toString()));
                    }
                    if (StandardWatchEventKinds.ENTRY_MODIFY == event.kind()) {
                        this.blockingQueue.offer(new ConfigFileChange(ConfigFileChange.ChangeType.UPDATE, event.context().toString()));
                    }
                    if (StandardWatchEventKinds.ENTRY_DELETE != event.kind()) continue;
                    this.blockingQueue.offer(new ConfigFileChange(ConfigFileChange.ChangeType.DELETE, event.context().toString()));
                }
                key.reset();
            }
        });
    }

    public ConfigFile loadConfigFile(String fileName) {
        String persistFilePathStr = this.persistDirPath + File.separator + fileName;
        Path persistPath = FileSystems.getDefault().getPath(persistFilePathStr, new String[0]);
        File persistFile = persistPath.toFile();
        if (null == persistFile || !persistFile.exists()) {
            return null;
        }
        return this.loadConfigFile(persistPath.toFile(), this.fileNameToConfigFile(fileName));
    }

    private static String configFileToFileName(ConfigFile configFile) {
        try {
            String encodedNamespace = URLEncoder.encode(configFile.getNamespace(), "UTF-8");
            String encodedFileGroup = URLEncoder.encode(configFile.getFileGroup(), "UTF-8");
            String encodeFileName = URLEncoder.encode(configFile.getFileName(), "UTF-8");
            return String.format("%s#%s#%s.yaml", encodedNamespace, encodedFileGroup, encodeFileName);
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 is unknown");
        }
    }

    private ConfigFile fileNameToConfigFile(String fileName) {
        fileName = fileName.substring(0, fileName.length() - CACHE_SUFFIX.length());
        String[] pieces = fileName.split("#");
        try {
            String namespace = URLDecoder.decode(pieces[0], "UTF-8");
            String fileGroup = URLDecoder.decode(pieces[1], "UTF-8");
            String configFileName = URLDecoder.decode(pieces[2], "UTF-8");
            return new ConfigFile(namespace, fileGroup, configFileName);
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 is unknown");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigFile loadConfigFile(File persistFile, ConfigFile configFile) {
        if (null == persistFile || !persistFile.exists()) {
            return null;
        }
        FileInputStream inputStream2 = null;
        InputStreamReader reader = null;
        Yaml yaml = new Yaml();
        try {
            inputStream2 = new FileInputStream(persistFile);
            reader = new InputStreamReader((InputStream)inputStream2, StandardCharsets.UTF_8);
            ConfigFile resConfigFile = new ConfigFile(configFile.getNamespace(), configFile.getFileGroup(), configFile.getFileName());
            Map jsonMap = (Map)yaml.load(reader);
            resConfigFile.setContent(jsonMap.get("content").toString());
            resConfigFile.setMd5(jsonMap.get("md5").toString());
            resConfigFile.setVersion(Long.valueOf(String.valueOf(jsonMap.get("version"))));
            ConfigFile configFile2 = resConfigFile;
            return configFile2;
        }
        catch (IOException e) {
            LOGGER.warn("fail to read file :" + persistFile.getAbsoluteFile(), (Throwable)e);
            ConfigFile configFile3 = null;
            return configFile3;
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LOGGER.warn("fail to close reader for :" + persistFile.getAbsoluteFile(), (Throwable)e);
                }
            }
            if (null != inputStream2) {
                try {
                    ((InputStream)inputStream2).close();
                }
                catch (IOException e) {
                    LOGGER.warn("fail to close stream for :" + persistFile.getAbsoluteFile(), (Throwable)e);
                }
            }
        }
    }
}

