/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.core;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.naming.Name;
import javax.naming.directory.Attributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import org.springframework.LdapDataEntry;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.AuthenticatedLdapEntryContextMapper;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DefaultLdapClientBuilder;
import org.springframework.ldap.core.NameClassPairMapper;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.ldap.query.LdapQueryBuilder;

public interface LdapClient {
    public ListSpec list(String var1);

    public ListSpec list(Name var1);

    public ListBindingsSpec listBindings(String var1);

    public ListBindingsSpec listBindings(Name var1);

    public SearchSpec search();

    public AuthenticateSpec authenticate();

    public BindSpec bind(String var1);

    public BindSpec bind(Name var1);

    public ModifySpec modify(String var1);

    public ModifySpec modify(Name var1);

    public UnbindSpec unbind(String var1);

    public UnbindSpec unbind(Name var1);

    public Builder mutate();

    public static LdapClient create(ContextSource contextSource) {
        return new DefaultLdapClientBuilder().contextSource(contextSource).build();
    }

    public static Builder builder() {
        return new DefaultLdapClientBuilder();
    }

    public static interface UnbindSpec {
        public UnbindSpec recursive(boolean var1);

        public void execute();
    }

    public static interface ModifySpec {
        public ModifySpec name(String var1);

        public ModifySpec name(Name var1);

        public ModifySpec attributes(ModificationItem ... var1);

        public void execute();
    }

    public static interface BindSpec {
        public BindSpec object(Object var1);

        public BindSpec attributes(Attributes var1);

        public BindSpec replaceExisting(boolean var1);

        public void execute();
    }

    public static interface AuthenticateSpec {
        public AuthenticateSpec query(LdapQuery var1);

        public AuthenticateSpec password(String var1);

        public void execute();

        public <T> T execute(AuthenticatedLdapEntryContextMapper<T> var1);
    }

    public static interface SearchSpec {
        public SearchSpec name(String var1);

        public SearchSpec name(Name var1);

        public SearchSpec query(Consumer<LdapQueryBuilder> var1);

        public SearchSpec query(LdapQuery var1);

        default public <O extends LdapDataEntry> O toEntry() {
            ContextMapper<LdapDataEntry> cast = ctx -> (LdapDataEntry)ctx;
            return (O)this.toObject(cast);
        }

        public <O> O toObject(ContextMapper<O> var1);

        public <O> O toObject(AttributesMapper<O> var1);

        default public <O extends LdapDataEntry> List<O> toEntryList() {
            ContextMapper<LdapDataEntry> cast = ctx -> (LdapDataEntry)ctx;
            return this.toList(cast);
        }

        public <O> List<O> toList(ContextMapper<O> var1);

        public <O> List<O> toList(AttributesMapper<O> var1);

        default public <O extends LdapDataEntry> Stream<O> toEntryStream() {
            ContextMapper<LdapDataEntry> cast = ctx -> (LdapDataEntry)ctx;
            return this.toStream(cast);
        }

        public <O> Stream<O> toStream(ContextMapper<O> var1);

        public <O> Stream<O> toStream(AttributesMapper<O> var1);
    }

    public static interface ListBindingsSpec {
        public <T> List<T> toList(NameClassPairMapper<T> var1);

        public <T> List<T> toList(ContextMapper<T> var1);

        public <T> Stream<T> toStream(NameClassPairMapper<T> var1);

        public <T> Stream<T> toStream(ContextMapper<T> var1);
    }

    public static interface ListSpec {
        public <T> List<T> toList(NameClassPairMapper<T> var1);

        public <T> Stream<T> toStream(NameClassPairMapper<T> var1);
    }

    public static interface Builder {
        public Builder contextSource(ContextSource var1);

        public Builder defaultSearchControls(Supplier<SearchControls> var1);

        public Builder ignorePartialResultException(boolean var1);

        public Builder ignoreNameNotFoundException(boolean var1);

        public Builder ignoreSizeLimitExceededException(boolean var1);

        public Builder apply(Consumer<Builder> var1);

        public Builder clone();

        public LdapClient build();
    }
}

