/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.resource;

import io.lettuce.core.RedisURI;
import io.lettuce.core.internal.HostAndPort;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.resource.DnsResolver;
import io.lettuce.core.resource.SocketAddressResolver;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.function.Function;

public class MappingSocketAddressResolver
extends SocketAddressResolver {
    private final Function<HostAndPort, HostAndPort> mappingFunction;
    private final DnsResolver dnsResolver;

    private MappingSocketAddressResolver(Function<HostAndPort, HostAndPort> mappingFunction) {
        this(DnsResolver.unresolved(), mappingFunction);
    }

    private MappingSocketAddressResolver(DnsResolver dnsResolver, Function<HostAndPort, HostAndPort> mappingFunction) {
        super(dnsResolver);
        LettuceAssert.notNull(mappingFunction, "Mapping function must not be null!");
        this.dnsResolver = dnsResolver;
        this.mappingFunction = mappingFunction;
    }

    public static MappingSocketAddressResolver create(Function<HostAndPort, HostAndPort> mappingFunction) {
        return new MappingSocketAddressResolver(mappingFunction);
    }

    public static MappingSocketAddressResolver create(DnsResolver dnsResolver, Function<HostAndPort, HostAndPort> mappingFunction) {
        return new MappingSocketAddressResolver(dnsResolver, mappingFunction);
    }

    @Override
    public SocketAddress resolve(RedisURI redisURI) {
        if (redisURI.getSocket() != null) {
            return MappingSocketAddressResolver.getDomainSocketAddress(redisURI);
        }
        HostAndPort hostAndPort = HostAndPort.of(redisURI.getHost(), redisURI.getPort());
        HostAndPort mapped = this.mappingFunction.apply(hostAndPort);
        if (mapped == null) {
            throw new IllegalStateException("Mapping function must not return null for HostAndPort");
        }
        try {
            return this.doResolve(mapped);
        }
        catch (UnknownHostException e) {
            return new InetSocketAddress(redisURI.getHost(), redisURI.getPort());
        }
    }

    private SocketAddress doResolve(HostAndPort mapped) throws UnknownHostException {
        InetAddress[] inetAddress = this.dnsResolver.resolve(mapped.getHostText());
        if (inetAddress.length == 0) {
            return InetSocketAddress.createUnresolved(mapped.getHostText(), mapped.getPort());
        }
        return new InetSocketAddress(inetAddress[0], mapped.getPort());
    }
}

