/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.GeoShapeRelation;
import co.elastic.clients.elasticsearch._types.query_dsl.FieldLookup;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ShapeFieldQuery
implements JsonpSerializable {
    @Nullable
    private final FieldLookup indexedShape;
    @Nullable
    private final GeoShapeRelation relation;
    @Nullable
    private final JsonData shape;
    public static final JsonpDeserializer<ShapeFieldQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShapeFieldQuery::setupShapeFieldQueryDeserializer);

    private ShapeFieldQuery(Builder builder) {
        this.indexedShape = builder.indexedShape;
        this.relation = builder.relation;
        this.shape = builder.shape;
    }

    public static ShapeFieldQuery of(Function<Builder, ObjectBuilder<ShapeFieldQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final FieldLookup indexedShape() {
        return this.indexedShape;
    }

    @Nullable
    public final GeoShapeRelation relation() {
        return this.relation;
    }

    @Nullable
    public final JsonData shape() {
        return this.shape;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.indexedShape != null) {
            generator.writeKey("indexed_shape");
            this.indexedShape.serialize(generator, mapper);
        }
        if (this.relation != null) {
            generator.writeKey("relation");
            this.relation.serialize(generator, mapper);
        }
        if (this.shape != null) {
            generator.writeKey("shape");
            this.shape.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupShapeFieldQueryDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::indexedShape, FieldLookup._DESERIALIZER, "indexed_shape");
        op.add(Builder::relation, GeoShapeRelation._DESERIALIZER, "relation");
        op.add(Builder::shape, JsonData._DESERIALIZER, "shape");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ShapeFieldQuery> {
        @Nullable
        private FieldLookup indexedShape;
        @Nullable
        private GeoShapeRelation relation;
        @Nullable
        private JsonData shape;

        public final Builder indexedShape(@Nullable FieldLookup value) {
            this.indexedShape = value;
            return this;
        }

        public final Builder indexedShape(Function<FieldLookup.Builder, ObjectBuilder<FieldLookup>> fn) {
            return this.indexedShape(fn.apply(new FieldLookup.Builder()).build());
        }

        public final Builder relation(@Nullable GeoShapeRelation value) {
            this.relation = value;
            return this;
        }

        public final Builder shape(@Nullable JsonData value) {
            this.shape = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ShapeFieldQuery build() {
            this._checkSingleUse();
            return new ShapeFieldQuery(this);
        }
    }
}

