/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.tool.support;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.annotation.Tool;
import org.springframework.ai.tool.execution.DefaultToolCallResultConverter;
import org.springframework.ai.tool.execution.ToolCallResultConverter;
import org.springframework.ai.util.ParsingUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class ToolUtils {
    private ToolUtils() {
    }

    public static String getToolName(Method method) {
        Assert.notNull((Object)method, (String)"method cannot be null");
        Tool tool = method.getAnnotation(Tool.class);
        if (tool == null) {
            return method.getName();
        }
        return StringUtils.hasText((String)tool.name()) ? tool.name() : method.getName();
    }

    public static String getToolDescriptionFromName(String toolName) {
        Assert.hasText((String)toolName, (String)"toolName cannot be null or empty");
        return ParsingUtils.reConcatenateCamelCase((String)toolName, (String)" ");
    }

    public static String getToolDescription(Method method) {
        Assert.notNull((Object)method, (String)"method cannot be null");
        Tool tool = method.getAnnotation(Tool.class);
        if (tool == null) {
            return ParsingUtils.reConcatenateCamelCase((String)method.getName(), (String)" ");
        }
        return StringUtils.hasText((String)tool.description()) ? tool.description() : method.getName();
    }

    public static boolean getToolReturnDirect(Method method) {
        Assert.notNull((Object)method, (String)"method cannot be null");
        Tool tool = method.getAnnotation(Tool.class);
        return tool != null && tool.returnDirect();
    }

    public static ToolCallResultConverter getToolCallResultConverter(Method method) {
        Assert.notNull((Object)method, (String)"method cannot be null");
        Tool tool = method.getAnnotation(Tool.class);
        if (tool == null) {
            return new DefaultToolCallResultConverter();
        }
        Class<? extends ToolCallResultConverter> type = tool.resultConverter();
        try {
            return type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to instantiate ToolCallResultConverter: " + String.valueOf(type), e);
        }
    }

    public static List<String> getDuplicateToolNames(List<ToolCallback> toolCallbacks) {
        Assert.notNull(toolCallbacks, (String)"toolCallbacks cannot be null");
        return toolCallbacks.stream().collect(Collectors.groupingBy(toolCallback -> toolCallback.getToolDefinition().name(), Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public static List<String> getDuplicateToolNames(ToolCallback ... toolCallbacks) {
        Assert.notNull((Object)toolCallbacks, (String)"toolCallbacks cannot be null");
        return ToolUtils.getDuplicateToolNames(Arrays.asList(toolCallbacks));
    }
}

