/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.response;

import java.util.Map;
import java.util.Objects;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.context.ShenyuContext;
import org.apache.shenyu.plugin.response.strategy.MessageWriter;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ResponsePlugin
implements ShenyuPlugin {
    private final Map<String, MessageWriter> writerMap;

    public ResponsePlugin(Map<String, MessageWriter> writerMap) {
        this.writerMap = writerMap;
    }

    public Mono<Void> execute(ServerWebExchange exchange, ShenyuPluginChain chain) {
        ShenyuContext shenyuContext = (ShenyuContext)exchange.getAttribute("context");
        Objects.requireNonNull(shenyuContext);
        return this.writerMap.get(shenyuContext.getRpcType()).writeWith(exchange, chain);
    }

    public int getOrder() {
        return PluginEnum.RESPONSE.getCode();
    }

    public String named() {
        return PluginEnum.RESPONSE.getName();
    }
}

