/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.net.core;

import com.qq.tars.net.core.Session;
import com.qq.tars.net.protocol.ProtocolException;
import java.io.IOException;

public abstract class Response {
    private int ticketNum = -1;
    protected transient Session session = null;
    protected transient boolean asyncMode = false;
    private volatile boolean committed = false;

    public Response(Session session) {
        this.session = session;
    }

    public void init() throws ProtocolException {
    }

    public Session getSession() {
        return this.session;
    }

    public boolean isAsyncMode() {
        return this.asyncMode;
    }

    public void asyncCallStart() throws IOException {
        this.asyncMode = true;
    }

    public void asyncCallEnd() throws IOException {
        if (!this.asyncMode) {
            throw new IllegalStateException("The response is not async mode.");
        }
        this.ensureNotCommitted();
        this.session.write(this);
    }

    public void setTicketNumber(int ticketNum) {
        this.ticketNum = ticketNum;
    }

    public int getTicketNumber() {
        return this.ticketNum;
    }

    private synchronized void ensureNotCommitted() {
        if (this.committed) {
            throw new IllegalStateException("Not allowed after response has committed.");
        }
        this.committed = true;
    }
}

