/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.auth.filter;

import org.apache.dubbo.auth.spi.Authenticator;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.model.ApplicationModel;

@Activate(group={"consumer"}, value={"auth"}, order=-10000)
public class ConsumerSignFilter
implements Filter {
    private final ApplicationModel applicationModel;

    public ConsumerSignFilter(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
    }

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        URL url = invoker.getUrl();
        boolean shouldAuth = url.getParameter("auth", false);
        if (shouldAuth) {
            Authenticator authenticator = this.applicationModel.getExtensionLoader(Authenticator.class).getExtension(url.getParameter("authenticator", "accesskey"));
            authenticator.sign(invocation, url);
        }
        return invoker.invoke(invocation);
    }
}

