/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http.restclient;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpMethod;
import org.apache.dubbo.remoting.http.RequestTemplate;
import org.apache.dubbo.remoting.http.RestClient;
import org.apache.dubbo.remoting.http.RestResult;
import org.apache.dubbo.remoting.http.config.HttpClientConfig;

public class OKHttpRestClient
implements RestClient {
    private final OkHttpClient okHttpClient;
    private final HttpClientConfig httpClientConfig;

    public OKHttpRestClient(HttpClientConfig clientConfig) {
        this.okHttpClient = this.createHttpClient(clientConfig);
        this.httpClientConfig = clientConfig;
    }

    @Override
    public CompletableFuture<RestResult> send(RequestTemplate requestTemplate) {
        Request.Builder builder = new Request.Builder();
        builder.url(requestTemplate.getURL());
        Map<String, Collection<String>> allHeaders = requestTemplate.getAllHeaders();
        boolean hasBody = false;
        RequestBody requestBody = null;
        if (HttpMethod.permitsRequestBody((String)requestTemplate.getHttpMethod())) {
            requestBody = RequestBody.create(null, (byte[])requestTemplate.getSerializedBody());
            hasBody = true;
        }
        for (String headerName : allHeaders.keySet()) {
            Collection<String> headerValues = allHeaders.get(headerName);
            if (!hasBody && "Content-Length".equals(headerName)) continue;
            for (String headerValue : headerValues) {
                builder.addHeader(headerName, headerValue);
            }
        }
        builder.method(requestTemplate.getHttpMethod(), requestBody);
        final CompletableFuture<RestResult> future = new CompletableFuture<RestResult>();
        this.okHttpClient.newCall(builder.build()).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                future.completeExceptionally(e);
            }

            public void onResponse(Call call, final Response response) throws IOException {
                future.complete(new RestResult(){

                    @Override
                    public String getContentType() {
                        return response.header("Content-Type");
                    }

                    @Override
                    public byte[] getBody() throws IOException {
                        ResponseBody body = response.body();
                        return body == null ? null : body.bytes();
                    }

                    @Override
                    public Map<String, List<String>> headers() {
                        return response.headers().toMultimap();
                    }

                    @Override
                    public byte[] getErrorResponse() throws IOException {
                        return this.getBody();
                    }

                    @Override
                    public int getResponseCode() throws IOException {
                        return response.code();
                    }

                    @Override
                    public String getMessage() throws IOException {
                        return this.appendErrorMessage(response.message(), new String(this.getBody()));
                    }
                });
            }
        });
        return future;
    }

    @Override
    public void close() {
        this.okHttpClient.connectionPool().evictAll();
    }

    @Override
    public void close(int timeout) {
    }

    @Override
    public boolean isClosed() {
        return this.okHttpClient.retryOnConnectionFailure();
    }

    public OkHttpClient createHttpClient(HttpClientConfig httpClientConfig) {
        return new OkHttpClient.Builder().readTimeout((long)httpClientConfig.getReadTimeout(), TimeUnit.SECONDS).writeTimeout((long)httpClientConfig.getWriteTimeout(), TimeUnit.SECONDS).connectTimeout((long)httpClientConfig.getConnectTimeout(), TimeUnit.SECONDS).connectionPool(new ConnectionPool(httpClientConfig.getMaxIdleConnections(), (long)httpClientConfig.getKeepAliveDuration(), TimeUnit.SECONDS)).build();
    }
}

