/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.stream;

import java.util.concurrent.Executor;
import org.apache.dubbo.common.threadpool.serial.SerializingExecutor;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.stream.Stream;

public abstract class AbstractStream
implements Stream {
    protected Executor executor;
    protected final FrameworkModel frameworkModel;
    private static final boolean HAS_PROTOBUF = AbstractStream.hasProtobuf();

    public AbstractStream(Executor executor, FrameworkModel frameworkModel) {
        this.executor = new SerializingExecutor(executor);
        this.frameworkModel = frameworkModel;
    }

    public void setExecutor(Executor executor) {
        this.executor = new SerializingExecutor(executor);
    }

    public static boolean getGrpcStatusDetailEnabled() {
        return HAS_PROTOBUF;
    }

    private static boolean hasProtobuf() {
        try {
            ClassUtils.forName("com.google.protobuf.Message");
            return true;
        }
        catch (ClassNotFoundException ignore) {
            return false;
        }
    }
}

