/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.visitor;

import graphql.Internal;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLModifiedType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.visitor.GraphQLSchemaTraversalControl;
import graphql.schema.visitor.GraphQLSchemaVisitorEnvironment;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

@Internal
class GraphQLSchemaVisitorEnvironmentImpl<T extends GraphQLSchemaElement>
implements GraphQLSchemaVisitorEnvironment<T> {
    protected final TraverserContext<GraphQLSchemaElement> context;

    GraphQLSchemaVisitorEnvironmentImpl(TraverserContext<GraphQLSchemaElement> context) {
        this.context = context;
    }

    @Override
    public GraphQLSchema getSchema() {
        return this.context.getVarFromParents(GraphQLSchema.class);
    }

    @Override
    public GraphQLCodeRegistry.Builder getCodeRegistry() {
        return this.context.getVarFromParents(GraphQLCodeRegistry.Builder.class);
    }

    @Override
    public T getElement() {
        return (T)this.context.thisNode();
    }

    @Override
    public List<GraphQLSchemaElement> getLeadingElements() {
        return this.buildParentsImpl(schemaElement -> true);
    }

    @Override
    public List<GraphQLSchemaElement> getUnwrappedLeadingElements() {
        return this.buildParentsImpl(schemaElement -> !(schemaElement instanceof GraphQLModifiedType));
    }

    @NotNull
    private List<GraphQLSchemaElement> buildParentsImpl(Predicate<GraphQLSchemaElement> predicate) {
        ArrayList<GraphQLSchemaElement> list = new ArrayList<GraphQLSchemaElement>();
        for (TraverserContext<GraphQLSchemaElement> parentContext = this.context.getParentContext(); parentContext != null; parentContext = parentContext.getParentContext()) {
            GraphQLSchemaElement parentNode = parentContext.thisNode();
            if (parentNode == null || !predicate.test(parentNode)) continue;
            list.add(parentNode);
        }
        return list;
    }

    @Override
    public GraphQLSchemaTraversalControl ok() {
        return GraphQLSchemaTraversalControl.CONTINUE;
    }

    @Override
    public GraphQLSchemaTraversalControl quit() {
        return GraphQLSchemaTraversalControl.QUIT;
    }

    @Override
    public GraphQLSchemaTraversalControl changeNode(T schemaElement) {
        return new GraphQLSchemaTraversalControl(GraphQLSchemaTraversalControl.Control.CHANGE, (GraphQLSchemaElement)schemaElement);
    }

    @Override
    public GraphQLSchemaTraversalControl deleteNode() {
        return GraphQLSchemaTraversalControl.DELETE;
    }

    @Override
    public GraphQLSchemaTraversalControl insertAfter(T toInsertAfter) {
        return new GraphQLSchemaTraversalControl(GraphQLSchemaTraversalControl.Control.INSERT_AFTER, (GraphQLSchemaElement)toInsertAfter);
    }

    @Override
    public GraphQLSchemaTraversalControl insertBefore(T toInsertBefore) {
        return new GraphQLSchemaTraversalControl(GraphQLSchemaTraversalControl.Control.INSERT_BEFORE, (GraphQLSchemaElement)toInsertBefore);
    }
}

