/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.manual.networkalias.NetworkAddressAlias;
import org.apache.skywalking.oap.server.core.storage.StorageData;
import org.apache.skywalking.oap.server.core.storage.cache.INetworkAddressAliasDAO;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCClient;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.TableHelper;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao.JDBCSQLExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCNetworkAddressAliasDAO
extends JDBCSQLExecutor
implements INetworkAddressAliasDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JDBCNetworkAddressAliasDAO.class);
    private final JDBCClient jdbcClient;
    private final TableHelper tableHelper;

    public JDBCNetworkAddressAliasDAO(JDBCClient jdbcClient, ModuleManager moduleManager) {
        this.jdbcClient = jdbcClient;
        this.tableHelper = new TableHelper(moduleManager, jdbcClient);
    }

    public List<NetworkAddressAlias> loadLastUpdate(long lastUpdateTime) {
        List<String> tables = this.tableHelper.getTablesWithinTTL("network_address_alias");
        ArrayList<NetworkAddressAlias> results = new ArrayList<NetworkAddressAlias>();
        for (String table : tables) {
            StringBuilder sql = new StringBuilder().append("select * from ").append(table).append(" where ").append("table_name").append(" = ? ").append(" and ").append("last_update_time_bucket").append(">?");
            results.addAll((Collection)this.jdbcClient.executeQuery(sql.toString(), resultSet -> {
                NetworkAddressAlias networkAddressAlias;
                ArrayList<NetworkAddressAlias> networkAddressAliases = new ArrayList<NetworkAddressAlias>();
                do {
                    if ((networkAddressAlias = (NetworkAddressAlias)this.toStorageData(resultSet, "network_address_alias", (StorageBuilder<? extends StorageData>)new NetworkAddressAlias.Builder())) == null) continue;
                    networkAddressAliases.add(networkAddressAlias);
                } while (networkAddressAlias != null);
                return networkAddressAliases;
            }, new Object[]{"network_address_alias", lastUpdateTime}));
        }
        return results;
    }
}

