/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao;

import com.google.common.base.Strings;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.Tag;
import org.apache.skywalking.oap.server.core.analysis.manual.segment.SegmentRecord;
import org.apache.skywalking.oap.server.core.config.ConfigService;
import org.apache.skywalking.oap.server.core.config.SearchableTracesTagsWatcher;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.BasicTrace;
import org.apache.skywalking.oap.server.core.query.type.QueryOrder;
import org.apache.skywalking.oap.server.core.query.type.Span;
import org.apache.skywalking.oap.server.core.query.type.TraceBrief;
import org.apache.skywalking.oap.server.core.query.type.TraceState;
import org.apache.skywalking.oap.server.core.storage.query.ITraceQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCClient;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.BooleanUtils;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.TableHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCTraceQueryDAO
implements ITraceQueryDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JDBCTraceQueryDAO.class);
    private final ModuleManager manager;
    private final JDBCClient jdbcClient;
    private final TableHelper tableHelper;
    private SearchableTracesTagsWatcher searchableTagKeys;
    private static String DETAIL_SELECT_QUERY = "select segment_id, trace_id, endpoint_id, service_id, service_instance_id, start_time, latency, is_error, data_binary";

    public TraceBrief queryBasicTraces(Duration duration, long minDuration, long maxDuration, String serviceId, String serviceInstanceId, String endpointId, String traceId, int limit, int from, TraceState traceState, QueryOrder queryOrder, List<Tag> tags) throws IOException {
        if (this.searchableTagKeys == null) {
            ConfigService configService = (ConfigService)this.manager.find("core").provider().getService(ConfigService.class);
            this.searchableTagKeys = configService.getSearchableTracesTags();
        }
        if (tags != null && !this.searchableTagKeys.getSearchableTags().containsAll(tags.stream().map(Tag::getKey).collect(Collectors.toSet()))) {
            log.warn("Searching tags that are not searchable: {}", tags.stream().map(Tag::getKey).filter(Predicate.not(this.searchableTagKeys.getSearchableTags()::contains)).collect(Collectors.toSet()));
            return new TraceBrief();
        }
        long startSecondTB = 0L;
        long endSecondTB = 0L;
        if (Objects.nonNull(duration)) {
            startSecondTB = duration.getStartTimeBucketInSec();
            endSecondTB = duration.getEndTimeBucketInSec();
        }
        List<String> tables = startSecondTB > 0L && endSecondTB > 0L ? this.tableHelper.getTablesForRead("segment", startSecondTB, endSecondTB) : this.tableHelper.getTablesWithinTTL("segment");
        ArrayList traces = new ArrayList();
        for (String table : tables) {
            int i;
            StringBuilder sql = new StringBuilder();
            ArrayList<Object> parameters = new ArrayList<Object>(10);
            sql.append("from ").append(table);
            long timeBucket = TableHelper.getTimeBucket(table);
            String tagTable = TableHelper.getTable("segment_tag", timeBucket);
            if (!CollectionUtils.isEmpty(tags)) {
                for (i = 0; i < tags.size(); ++i) {
                    sql.append(" inner join ").append(tagTable).append(" ");
                    sql.append(tagTable + i);
                    sql.append(" on ").append(table).append(".").append("id").append(" = ");
                    sql.append(tagTable + i).append(".").append("id");
                }
            }
            sql.append(" where ");
            sql.append("table_name").append(" = ?");
            parameters.add("segment");
            if (startSecondTB != 0L && endSecondTB != 0L) {
                sql.append(" and ").append(table).append(".").append("time_bucket").append(" >= ?");
                parameters.add(startSecondTB);
                sql.append(" and ").append(table).append(".").append("time_bucket").append(" <= ?");
                parameters.add(endSecondTB);
            }
            if (minDuration != 0L) {
                sql.append(" and ").append("latency").append(" >= ?");
                parameters.add(minDuration);
            }
            if (maxDuration != 0L) {
                sql.append(" and ").append("latency").append(" <= ?");
                parameters.add(maxDuration);
            }
            if (StringUtil.isNotEmpty((String)serviceId)) {
                sql.append(" and ").append(table).append(".").append("service_id").append(" = ?");
                parameters.add(serviceId);
            }
            if (StringUtil.isNotEmpty((String)serviceInstanceId)) {
                sql.append(" and ").append("service_instance_id").append(" = ?");
                parameters.add(serviceInstanceId);
            }
            if (!Strings.isNullOrEmpty((String)endpointId)) {
                sql.append(" and ").append("endpoint_id").append(" = ?");
                parameters.add(endpointId);
            }
            if (!Strings.isNullOrEmpty((String)traceId)) {
                sql.append(" and ").append("trace_id").append(" = ?");
                parameters.add(traceId);
            }
            if (CollectionUtils.isNotEmpty(tags)) {
                for (i = 0; i < tags.size(); ++i) {
                    sql.append(" and ").append(tagTable + i).append(".");
                    sql.append("tags").append(" = ?");
                    parameters.add(tags.get(i).toString());
                }
            }
            switch (traceState) {
                case ERROR: {
                    sql.append(" and ").append("is_error").append(" = ").append(1);
                    break;
                }
                case SUCCESS: {
                    sql.append(" and ").append("is_error").append(" = ").append(0);
                }
            }
            switch (queryOrder) {
                case BY_START_TIME: {
                    sql.append(" order by ").append("start_time").append(" ").append("desc");
                    break;
                }
                case BY_DURATION: {
                    sql.append(" order by ").append("latency").append(" ").append("desc");
                }
            }
            this.buildLimit(sql, from, limit);
            this.jdbcClient.executeQuery("select segment_id, start_time, endpoint_id, latency, is_error, trace_id " + sql, resultSet -> {
                while (resultSet.next()) {
                    BasicTrace basicTrace = new BasicTrace();
                    basicTrace.setSegmentId(resultSet.getString("segment_id"));
                    basicTrace.setStart(resultSet.getString("start_time"));
                    basicTrace.getEndpointNames().add(IDManager.EndpointID.analysisId((String)resultSet.getString("endpoint_id")).getEndpointName());
                    basicTrace.setDuration(resultSet.getInt("latency"));
                    basicTrace.setError(BooleanUtils.valueToBoolean((int)resultSet.getInt("is_error")));
                    String traceIds = resultSet.getString("trace_id");
                    basicTrace.getTraceIds().add(traceIds);
                    traces.add(basicTrace);
                }
                return null;
            }, parameters.toArray(new Object[0]));
        }
        return new TraceBrief(traces);
    }

    protected void buildLimit(StringBuilder sql, int from, int limit) {
        sql.append(" LIMIT ").append(limit);
        sql.append(" OFFSET ").append(from);
    }

    public List<SegmentRecord> queryByTraceId(String traceId) throws IOException {
        List<String> tables = this.tableHelper.getTablesWithinTTL("segment");
        ArrayList<SegmentRecord> segmentRecords = new ArrayList<SegmentRecord>();
        for (String table : tables) {
            this.jdbcClient.executeQuery(DETAIL_SELECT_QUERY + " from " + table + " where table_name = ? and trace_id = ?", resultSet -> {
                segmentRecords.addAll(this.buildRecords(resultSet));
                return null;
            }, new Object[]{"segment", traceId});
        }
        return segmentRecords;
    }

    public List<SegmentRecord> queryBySegmentIdList(List<String> segmentIdList) throws IOException {
        List<String> tables = this.tableHelper.getTablesWithinTTL("segment");
        ArrayList<SegmentRecord> segmentRecords = new ArrayList<SegmentRecord>();
        ArrayList<String> conditions = new ArrayList<String>();
        conditions.add("segment");
        conditions.addAll(segmentIdList);
        for (String table : tables) {
            this.jdbcClient.executeQuery(DETAIL_SELECT_QUERY + " from " + table + " where table_name = ? and segment_id in " + segmentIdList.stream().map(it -> "?").collect(Collectors.joining(",", "(", ")")), resultSet -> {
                segmentRecords.addAll(this.buildRecords(resultSet));
                return null;
            }, conditions.toArray());
        }
        return segmentRecords;
    }

    public List<SegmentRecord> queryByTraceIdWithInstanceId(List<String> traceIdList, List<String> instanceIdList) throws IOException {
        List<String> tables = this.tableHelper.getTablesWithinTTL("segment");
        ArrayList<SegmentRecord> segmentRecords = new ArrayList<SegmentRecord>();
        ArrayList<String> conditions = new ArrayList<String>();
        conditions.add("segment");
        conditions.addAll(traceIdList);
        conditions.addAll(instanceIdList);
        for (String table : tables) {
            this.jdbcClient.executeQuery(DETAIL_SELECT_QUERY + " from " + table + " where table_name = ? and trace_id in " + traceIdList.stream().map(it -> "?").collect(Collectors.joining(",", "(", ") and ")) + "service_instance_id in " + instanceIdList.stream().map(it -> "?").collect(Collectors.joining(",", "(", ")")), resultSet -> {
                segmentRecords.addAll(this.buildRecords(resultSet));
                return null;
            }, conditions.toArray());
        }
        return segmentRecords;
    }

    public List<Span> doFlexibleTraceQuery(String traceId) {
        return Collections.emptyList();
    }

    private List<SegmentRecord> buildRecords(ResultSet resultSet) throws SQLException {
        ArrayList<SegmentRecord> records = new ArrayList<SegmentRecord>();
        while (resultSet.next()) {
            SegmentRecord segmentRecord = new SegmentRecord();
            segmentRecord.setSegmentId(resultSet.getString("segment_id"));
            segmentRecord.setTraceId(resultSet.getString("trace_id"));
            segmentRecord.setEndpointId(resultSet.getString("endpoint_id"));
            segmentRecord.setServiceId(resultSet.getString("service_id"));
            segmentRecord.setServiceInstanceId(resultSet.getString("service_instance_id"));
            segmentRecord.setStartTime(resultSet.getLong("start_time"));
            segmentRecord.setLatency(resultSet.getInt("latency"));
            segmentRecord.setIsError(resultSet.getInt("is_error"));
            String dataBinaryBase64 = resultSet.getString("data_binary");
            if (!Strings.isNullOrEmpty((String)dataBinaryBase64)) {
                segmentRecord.setDataBinary(Base64.getDecoder().decode(dataBinaryBase64));
            }
            records.add(segmentRecord);
        }
        return records;
    }

    @Generated
    public JDBCTraceQueryDAO(ModuleManager manager, JDBCClient jdbcClient, TableHelper tableHelper) {
        this.manager = manager;
        this.jdbcClient = jdbcClient;
        this.tableHelper = tableHelper;
    }
}

