/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.mysql;

import com.google.gson.JsonObject;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.storage.model.ModelColumn;
import org.apache.skywalking.oap.server.core.storage.type.StorageDataComplexObject;
import org.apache.skywalking.oap.server.library.client.Client;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.JDBCTableInstaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLTableInstaller
extends JDBCTableInstaller {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MySQLTableInstaller.class);

    public MySQLTableInstaller(Client client, ModuleManager moduleManager) {
        super(client, moduleManager);
    }

    public void start() {
        this.overrideColumnName("value", "value_");
        this.overrideColumnName("precision", "cal_precision");
        this.overrideColumnName("match", "match_num");
    }

    @Override
    public String getColumnDefinition(ModelColumn column) {
        String storageName = column.getColumnName().getStorageName();
        Class type = column.getType();
        if (StorageDataComplexObject.class.isAssignableFrom(type)) {
            return storageName + " MEDIUMTEXT";
        }
        if (String.class.equals((Object)type)) {
            if (column.getLength() > 16383) {
                return storageName + " MEDIUMTEXT";
            }
            return storageName + " VARCHAR(" + column.getLength() + ")";
        }
        if (JsonObject.class.equals((Object)type)) {
            if (column.getLength() > 16383) {
                return storageName + " MEDIUMTEXT";
            }
            return storageName + " VARCHAR(" + column.getLength() + ")";
        }
        return super.getColumnDefinition(column);
    }
}

