/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.exporter.provider;

import org.apache.skywalking.oap.server.core.exporter.ExporterModule;
import org.apache.skywalking.oap.server.core.exporter.LogExportService;
import org.apache.skywalking.oap.server.core.exporter.MetricValuesExportService;
import org.apache.skywalking.oap.server.core.exporter.TraceExportService;
import org.apache.skywalking.oap.server.exporter.provider.ExporterSetting;
import org.apache.skywalking.oap.server.exporter.provider.grpc.GRPCMetricsExporter;
import org.apache.skywalking.oap.server.exporter.provider.kafka.log.KafkaLogExporter;
import org.apache.skywalking.oap.server.exporter.provider.kafka.trace.KafkaTraceExporter;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;

public class ExporterProvider
extends ModuleProvider {
    private ExporterSetting setting;
    private GRPCMetricsExporter grpcMetricsExporter;
    private KafkaTraceExporter kafkaTraceExporter;
    private KafkaLogExporter kafkaLogExporter;

    public String name() {
        return "default";
    }

    public Class<? extends ModuleDefine> module() {
        return ExporterModule.class;
    }

    public ModuleProvider.ConfigCreator newConfigCreator() {
        return new ModuleProvider.ConfigCreator<ExporterSetting>(){

            public Class type() {
                return ExporterSetting.class;
            }

            public void onInitialized(ExporterSetting initialized) {
                ExporterProvider.this.setting = initialized;
            }
        };
    }

    public void prepare() throws ServiceNotProvidedException, ModuleStartException {
        this.grpcMetricsExporter = new GRPCMetricsExporter(this.setting);
        this.kafkaTraceExporter = new KafkaTraceExporter(this.getManager(), this.setting);
        this.kafkaLogExporter = new KafkaLogExporter(this.getManager(), this.setting);
        this.registerServiceImplementation(MetricValuesExportService.class, (Service)this.grpcMetricsExporter);
        this.registerServiceImplementation(TraceExportService.class, (Service)this.kafkaTraceExporter);
        this.registerServiceImplementation(LogExportService.class, (Service)this.kafkaLogExporter);
    }

    public void start() throws ServiceNotProvidedException, ModuleStartException {
        if (this.setting.isEnableGRPCMetrics()) {
            this.grpcMetricsExporter.start();
        }
        if (this.setting.isEnableKafkaTrace()) {
            this.kafkaTraceExporter.start();
        }
        if (this.setting.isEnableKafkaLog()) {
            this.kafkaLogExporter.start();
        }
    }

    public void notifyAfterCompleted() throws ServiceNotProvidedException, ModuleStartException {
        if (this.setting.isEnableGRPCMetrics()) {
            this.grpcMetricsExporter.fetchSubscriptionList();
        }
    }

    public String[] requiredModules() {
        return new String[]{"core"};
    }
}

