/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.graphql;

import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.server.graphql.protocol.GraphqlUtil;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.graphql.DefaultGraphqlService;
import com.linecorp.armeria.server.graphql.GraphqlErrorHandler;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQLError;
import graphql.validation.ValidationError;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

final class DefaultGraphqlErrorHandler
extends Enum<DefaultGraphqlErrorHandler>
implements GraphqlErrorHandler {
    public static final /* enum */ DefaultGraphqlErrorHandler INSTANCE = new DefaultGraphqlErrorHandler();
    private static final /* synthetic */ DefaultGraphqlErrorHandler[] $VALUES;

    public static DefaultGraphqlErrorHandler[] values() {
        return (DefaultGraphqlErrorHandler[])$VALUES.clone();
    }

    public static DefaultGraphqlErrorHandler valueOf(String name) {
        return Enum.valueOf(DefaultGraphqlErrorHandler.class, name);
    }

    @Override
    @Nonnull
    public HttpResponse handle(ServiceRequestContext ctx, ExecutionInput input, @Nullable ExecutionResult result, @Nullable Throwable cause) {
        MediaType produceType = GraphqlUtil.produceType((RequestHeaders)ctx.request().headers());
        assert (produceType != null);
        if (cause != null) {
            Map specification = cause instanceof GraphQLError ? ((GraphQLError)cause).toSpecification() : DefaultGraphqlErrorHandler.toSpecification(cause);
            return HttpResponse.ofJson((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR, (MediaType)produceType, (Object)specification);
        }
        if (result != null) {
            if (result.getErrors().stream().anyMatch(ValidationError.class::isInstance)) {
                return HttpResponse.ofJson((HttpStatus)HttpStatus.BAD_REQUEST, (MediaType)produceType, (Object)result.toSpecification());
            }
        }
        return HttpResponse.ofJson((MediaType)produceType, (Object)(result != null ? result.toSpecification() : ImmutableMap.of()));
    }

    private static Map<String, Object> toSpecification(Throwable cause) {
        Objects.requireNonNull(cause, "cause");
        String message = cause.getMessage() != null ? cause.getMessage() : cause.toString();
        return DefaultGraphqlService.toSpecification(message);
    }

    private static /* synthetic */ DefaultGraphqlErrorHandler[] $values() {
        return new DefaultGraphqlErrorHandler[]{INSTANCE};
    }

    static {
        $VALUES = DefaultGraphqlErrorHandler.$values();
    }
}

