/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.meter.analyzer.dsl;

import com.google.common.collect.ImmutableMap;
import groovy.lang.Closure;
import groovy.lang.ExpandoMetaClass;
import groovy.lang.GroovyObjectSupport;
import groovy.util.DelegatingScript;
import io.vavr.Function2;
import java.io.Serializable;
import java.time.Instant;
import java.util.Map;
import lombok.Generated;
import org.apache.skywalking.oap.meter.analyzer.dsl.DownsamplingType;
import org.apache.skywalking.oap.meter.analyzer.dsl.ExpressionParsingContext;
import org.apache.skywalking.oap.meter.analyzer.dsl.ExpressionParsingException;
import org.apache.skywalking.oap.meter.analyzer.dsl.NumberClosure;
import org.apache.skywalking.oap.meter.analyzer.dsl.Result;
import org.apache.skywalking.oap.meter.analyzer.dsl.SampleFamily;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Expression {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Expression.class);
    private static final ThreadLocal<Map<String, SampleFamily>> PROPERTY_REPOSITORY = new ThreadLocal();
    private final String metricName;
    private final String literal;
    private final DelegatingScript expression;

    public Expression(String metricName, String literal, DelegatingScript expression) {
        this.metricName = metricName;
        this.literal = literal;
        this.expression = expression;
        this.empower();
    }

    public ExpressionParsingContext parse() {
        try (ExpressionParsingContext ctx = ExpressionParsingContext.create();){
            Result r = this.run((Map<String, SampleFamily>)ImmutableMap.of());
            if (!r.isSuccess() && r.isThrowable()) {
                throw new ExpressionParsingException("failed to parse expression: " + this.literal + ", error:" + r.getError());
            }
            if (log.isDebugEnabled()) {
                log.debug("\"{}\" is parsed", (Object)this.literal);
            }
            ctx.validate(this.literal);
            ExpressionParsingContext expressionParsingContext = ctx;
            return expressionParsingContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result run(Map<String, SampleFamily> sampleFamilies) {
        PROPERTY_REPOSITORY.set(sampleFamilies);
        try {
            SampleFamily sf = (SampleFamily)this.expression.run();
            if (sf == SampleFamily.EMPTY) {
                if (!ExpressionParsingContext.get().isPresent() && log.isDebugEnabled()) {
                    log.debug("result of {} is empty by \"{}\"", sampleFamilies, (Object)this.literal);
                }
                Result result = Result.fail("Parsed result is an EMPTY sample family");
                return result;
            }
            Result result = Result.success(sf);
            return result;
        }
        catch (Throwable t) {
            log.error("failed to run \"{}\"", (Object)this.literal, (Object)t);
            Result result = Result.fail(t);
            return result;
        }
        finally {
            PROPERTY_REPOSITORY.remove();
        }
    }

    private void empower() {
        this.expression.setDelegate((Object)new ExpressionDelegate(this.metricName, this.literal));
        this.extendNumber(Number.class);
    }

    private void extendNumber(Class clazz) {
        ExpandoMetaClass expando = new ExpandoMetaClass(clazz, true, false);
        expando.registerInstanceMethod("plus", (Closure)new NumberClosure(this, (Function2<Number, SampleFamily, SampleFamily>)(Function2 & Serializable)(n, s) -> s.plus((Number)n)));
        expando.registerInstanceMethod("minus", (Closure)new NumberClosure(this, (Function2<Number, SampleFamily, SampleFamily>)(Function2 & Serializable)(n, s) -> s.minus((Number)n).negative()));
        expando.registerInstanceMethod("multiply", (Closure)new NumberClosure(this, (Function2<Number, SampleFamily, SampleFamily>)(Function2 & Serializable)(n, s) -> s.multiply((Number)n)));
        expando.registerInstanceMethod("div", (Closure)new NumberClosure(this, (Function2<Number, SampleFamily, SampleFamily>)(Function2 & Serializable)(n, s) -> s.newValue(v -> n.doubleValue() / v)));
        expando.initialize();
    }

    @Generated
    public String toString() {
        return "Expression(literal=" + this.literal + ")";
    }

    private static class ExpressionDelegate
    extends GroovyObjectSupport {
        public static final DownsamplingType AVG = DownsamplingType.AVG;
        public static final DownsamplingType SUM = DownsamplingType.SUM;
        public static final DownsamplingType LATEST = DownsamplingType.LATEST;
        public static final DownsamplingType SUM_PER_MIN = DownsamplingType.SUM_PER_MIN;
        public static final DownsamplingType MAX = DownsamplingType.MAX;
        public static final DownsamplingType MIN = DownsamplingType.MIN;
        private final String metricName;
        private final String literal;

        public SampleFamily propertyMissing(String sampleName) {
            ExpressionParsingContext.get().ifPresent(ctx -> {
                if (!ctx.samples.contains(sampleName)) {
                    ctx.samples.add(sampleName);
                }
            });
            Map<String, SampleFamily> sampleFamilies = PROPERTY_REPOSITORY.get();
            if (sampleFamilies == null) {
                return SampleFamily.EMPTY;
            }
            if (sampleFamilies.containsKey(sampleName)) {
                SampleFamily sampleFamily = sampleFamilies.get(sampleName);
                sampleFamily.context.setMetricName(this.metricName);
                return sampleFamily;
            }
            if (ExpressionParsingContext.get().isEmpty()) {
                log.warn("{} referred by \"{}\" doesn't exist in {}", new Object[]{sampleName, this.literal, sampleFamilies.keySet()});
            }
            return SampleFamily.EMPTY;
        }

        public Number time() {
            return Instant.now().getEpochSecond();
        }

        @Generated
        public ExpressionDelegate(String metricName, String literal) {
            this.metricName = metricName;
            this.literal = literal;
        }
    }
}

