/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.worker;

import java.io.IOException;
import java.util.Optional;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.storage.IBatchDAO;
import org.apache.skywalking.oap.server.core.storage.IRecordDAO;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.worker.AbstractWorker;
import org.apache.skywalking.oap.server.library.client.request.InsertRequest;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordPersistentWorker
extends AbstractWorker<Record> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecordPersistentWorker.class);
    private final Model model;
    private final IRecordDAO recordDAO;
    private final IBatchDAO batchDAO;
    private final Optional<AbstractWorker<Record>> nextExportWorker;

    RecordPersistentWorker(ModuleDefineHolder moduleDefineHolder, Model model, IRecordDAO recordDAO, AbstractWorker<Record> nextExportWorker) {
        super(moduleDefineHolder);
        this.model = model;
        this.recordDAO = recordDAO;
        this.batchDAO = (IBatchDAO)moduleDefineHolder.find("storage").provider().getService(IBatchDAO.class);
        this.nextExportWorker = Optional.ofNullable(nextExportWorker);
    }

    @Override
    public void in(Record record) {
        try {
            InsertRequest insertRequest = this.recordDAO.prepareBatchInsert(this.model, record);
            this.batchDAO.insert(insertRequest);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        this.nextExportWorker.ifPresent(exportWorker -> exportWorker.in(record));
    }
}

