/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.config;

import groovy.lang.Closure;
import groovy.lang.GroovyShell;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.CoreModuleConfig;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class HierarchyDefinitionService
implements Service {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HierarchyDefinitionService.class);
    private final Map<String, Map<String, MatchingRule>> hierarchyDefinition = new HashMap<String, Map<String, MatchingRule>>();
    private Map<String, Integer> layerLevels = new HashMap<String, Integer>();
    private Map<String, MatchingRule> matchingRules;

    public HierarchyDefinitionService(CoreModuleConfig moduleConfig) {
        if (moduleConfig.isEnableHierarchy()) {
            this.init();
            this.checkLayers();
        }
    }

    private void init() {
        try {
            Reader applicationReader = ResourceUtils.read((String)"hierarchy-definition.yml");
            Yaml yaml = new Yaml();
            Map config = (Map)yaml.loadAs(applicationReader, Map.class);
            Map hierarchy = (Map)config.get("hierarchy");
            Map matchingRules = (Map)config.get("auto-matching-rules");
            this.layerLevels = (Map)config.get("layer-levels");
            this.matchingRules = matchingRules.entrySet().stream().map(entry -> {
                MatchingRule matchingRule = new MatchingRule((String)entry.getKey(), (String)entry.getValue());
                return Map.entry((String)entry.getKey(), matchingRule);
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            hierarchy.forEach((layer, lowerLayers) -> {
                HashMap rules = new HashMap();
                lowerLayers.forEach((lowerLayer, ruleName) -> rules.put(lowerLayer, this.matchingRules.get(ruleName)));
                this.hierarchyDefinition.put((String)layer, rules);
            });
        }
        catch (FileNotFoundException e) {
            throw new UnexpectedException("hierarchy-definition.yml not found.", e);
        }
    }

    private void checkLayers() {
        this.layerLevels.keySet().forEach(layer -> {
            if (Layer.nameOf(layer).equals((Object)Layer.UNDEFINED)) {
                throw new IllegalArgumentException("hierarchy-definition.yml " + layer + " is not a valid layer name.");
            }
        });
        this.hierarchyDefinition.forEach((layer, lowerLayers) -> {
            Integer layerLevel = this.layerLevels.get(layer);
            if (this.layerLevels.get(layer) == null) {
                throw new IllegalArgumentException("hierarchy-definition.yml  layer-levels: " + layer + " is not defined");
            }
            for (String lowerLayer : lowerLayers.keySet()) {
                Integer lowerLayerLevel = this.layerLevels.get(lowerLayer);
                if (lowerLayerLevel == null) {
                    throw new IllegalArgumentException("hierarchy-definition.yml  layer-levels: " + lowerLayer + " is not defined.");
                }
                if (layerLevel > lowerLayerLevel) continue;
                throw new IllegalArgumentException("hierarchy-definition.yml hierarchy: " + layer + " layer-level should be greater than " + lowerLayer + " layer-level.");
            }
        });
    }

    @Generated
    public Map<String, Map<String, MatchingRule>> getHierarchyDefinition() {
        return this.hierarchyDefinition;
    }

    @Generated
    public Map<String, Integer> getLayerLevels() {
        return this.layerLevels;
    }

    public static class MatchingRule {
        private final String name;
        private final String expression;
        private final Closure<Boolean> closure;

        public MatchingRule(String name, String expression) {
            this.name = name;
            this.expression = expression;
            GroovyShell sh = new GroovyShell();
            this.closure = (Closure)sh.evaluate(expression);
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getExpression() {
            return this.expression;
        }

        @Generated
        public Closure<Boolean> getClosure() {
            return this.closure;
        }
    }
}

