/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.profiling.trace;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.worker.NoneStreamProcessor;
import org.apache.skywalking.oap.server.core.profiling.trace.ProfileTaskRecord;
import org.apache.skywalking.oap.server.core.query.type.ProfileTask;
import org.apache.skywalking.oap.server.core.query.type.ProfileTaskCreationResult;
import org.apache.skywalking.oap.server.core.storage.profiling.trace.IProfileTaskQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;

public class ProfileTaskMutationService
implements Service {
    private final ModuleManager moduleManager;
    private IProfileTaskQueryDAO profileTaskQueryDAO;

    private IProfileTaskQueryDAO getProfileTaskDAO() {
        if (this.profileTaskQueryDAO == null) {
            this.profileTaskQueryDAO = (IProfileTaskQueryDAO)this.moduleManager.find("storage").provider().getService(IProfileTaskQueryDAO.class);
        }
        return this.profileTaskQueryDAO;
    }

    public ProfileTaskCreationResult createTask(String serviceId, String endpointName, long monitorStartTime, int monitorDuration, int minDurationThreshold, int dumpPeriod, int maxSamplingCount) throws IOException {
        long taskEndTime;
        long taskStartTime = monitorStartTime > 0L ? monitorStartTime : System.currentTimeMillis();
        String errorMessage = this.checkDataSuccess(serviceId, endpointName, taskStartTime, taskEndTime = taskStartTime + TimeUnit.MINUTES.toMillis(monitorDuration), monitorDuration, minDurationThreshold, dumpPeriod, maxSamplingCount);
        if (errorMessage != null) {
            return ProfileTaskCreationResult.builder().errorReason(errorMessage).build();
        }
        long createTime = System.currentTimeMillis();
        ProfileTaskRecord task = new ProfileTaskRecord();
        task.setTaskId(createTime + "_" + serviceId);
        task.setServiceId(serviceId);
        task.setEndpointName(endpointName.trim());
        task.setStartTime(taskStartTime);
        task.setDuration(monitorDuration);
        task.setMinDurationThreshold(minDurationThreshold);
        task.setDumpPeriod(dumpPeriod);
        task.setCreateTime(createTime);
        task.setMaxSamplingCount(maxSamplingCount);
        task.setTimeBucket(TimeBucket.getMinuteTimeBucket(taskStartTime));
        NoneStreamProcessor.getInstance().in(task);
        return ProfileTaskCreationResult.builder().id(task.id().build()).build();
    }

    private String checkDataSuccess(String serviceId, String endpointName, long monitorStartTime, long monitorEndTime, int monitorDuration, int minDurationThreshold, int dumpPeriod, int maxSamplingCount) throws IOException {
        if (serviceId == null) {
            return "service cannot be null";
        }
        if (StringUtil.isEmpty((String)endpointName)) {
            return "endpoint name cannot be empty";
        }
        if (monitorDuration < 1) {
            return "monitor duration must greater than 1 minutes";
        }
        if (minDurationThreshold < 0) {
            return "min duration threshold must greater than or equals zero";
        }
        if (maxSamplingCount <= 0) {
            return "max sampling count must greater than zero";
        }
        if (monitorDuration > 15) {
            return "The duration of the monitoring task cannot be greater than 15 minutes";
        }
        if (dumpPeriod < 10) {
            return "dump period must be greater than or equals 10 milliseconds";
        }
        if (maxSamplingCount >= 10) {
            return "max sampling count must less than 10";
        }
        long endTimeBucket = TimeBucket.getMinuteTimeBucket(monitorEndTime);
        List<ProfileTask> alreadyHaveTaskList = this.getProfileTaskDAO().getTaskList(serviceId, null, null, endTimeBucket, 1);
        if (CollectionUtils.isNotEmpty(alreadyHaveTaskList)) {
            for (ProfileTask profileTask : alreadyHaveTaskList) {
                if (profileTask.getStartTime() + TimeUnit.MINUTES.toMillis(profileTask.getDuration()) < monitorStartTime) continue;
                return "current service already has monitor task execute at this time";
            }
        }
        return null;
    }

    @Generated
    public ProfileTaskMutationService(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }
}

