/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query.type;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.query.type.AsyncProfilerStackElement;
import org.apache.skywalking.oap.server.library.jfr.type.FrameTree;
import org.apache.skywalking.oap.server.library.jfr.type.JFREventType;

public class AsyncProfilerStackTree {
    private JFREventType type;
    private List<AsyncProfilerStackElement> elements;
    private int idGen = 0;

    public AsyncProfilerStackTree(JFREventType type, FrameTree tree) {
        this.type = type;
        this.elements = this.convertTree(-1, tree);
    }

    private List<AsyncProfilerStackElement> convertTree(int parentId, FrameTree tree) {
        AsyncProfilerStackElement asyncProfilerStackElement = new AsyncProfilerStackElement();
        asyncProfilerStackElement.setId(this.idGen++);
        asyncProfilerStackElement.setParentId(parentId);
        asyncProfilerStackElement.setCodeSignature(tree.getFrame());
        asyncProfilerStackElement.setTotal(tree.getTotal());
        asyncProfilerStackElement.setSelf(tree.getSelf());
        List children = tree.getChildren();
        ArrayList result = Lists.newArrayList((Object[])new AsyncProfilerStackElement[]{asyncProfilerStackElement});
        if (Objects.isNull(children) || children.isEmpty()) {
            return result;
        }
        for (FrameTree child : children) {
            List<AsyncProfilerStackElement> childElements = this.convertTree(asyncProfilerStackElement.getId(), child);
            result.addAll(childElements);
        }
        return result;
    }

    @Generated
    public void setType(JFREventType type) {
        this.type = type;
    }

    @Generated
    public void setElements(List<AsyncProfilerStackElement> elements) {
        this.elements = elements;
    }

    @Generated
    public void setIdGen(int idGen) {
        this.idGen = idGen;
    }

    @Generated
    public JFREventType getType() {
        return this.type;
    }

    @Generated
    public List<AsyncProfilerStackElement> getElements() {
        return this.elements;
    }

    @Generated
    public int getIdGen() {
        return this.idGen;
    }

    @Generated
    public AsyncProfilerStackTree() {
    }
}

