/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.source;

import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.source.ScopeDeclaration;
import org.apache.skywalking.oap.server.core.source.ScopeDefaultColumn;
import org.apache.skywalking.oap.server.core.source.SideCar;
import org.apache.skywalking.oap.server.core.source.Source;

@ScopeDeclaration(id=58, name="TCPServiceInstance", catalog="SERVICE_INSTANCE")
@ScopeDefaultColumn.VirtualColumnDefinition(fieldName="entityId", columnName="entity_id", isID=true, type=String.class)
public class TCPServiceInstance
extends Source {
    private volatile String entityId;
    @ScopeDefaultColumn.DefinedByField(columnName="service_id")
    private String serviceId;
    @ScopeDefaultColumn.DefinedByField(columnName="name", requireDynamicActive=true)
    private String name;
    @ScopeDefaultColumn.DefinedByField(columnName="service_name", requireDynamicActive=true)
    private String serviceName;
    private Layer serviceLayer;
    private List<String> tags;
    private Map<String, String> originalTags;
    private SideCar sideCar = new SideCar();
    private long receivedBytes;
    private long sentBytes;

    @Override
    public int scope() {
        return 58;
    }

    @Override
    public String getEntityId() {
        if (this.entityId == null) {
            this.entityId = IDManager.ServiceInstanceID.buildId(this.serviceId, this.name);
        }
        return this.entityId;
    }

    @Override
    public void prepare() {
        this.serviceId = IDManager.ServiceID.buildId(this.serviceName, this.serviceLayer.isNormal());
    }

    public String getTag(String key) {
        return this.originalTags.get(key);
    }

    @Generated
    public String getServiceId() {
        return this.serviceId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public String getServiceName() {
        return this.serviceName;
    }

    @Generated
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Generated
    public Layer getServiceLayer() {
        return this.serviceLayer;
    }

    @Generated
    public void setServiceLayer(Layer serviceLayer) {
        this.serviceLayer = serviceLayer;
    }

    @Generated
    public List<String> getTags() {
        return this.tags;
    }

    @Generated
    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @Generated
    public void setOriginalTags(Map<String, String> originalTags) {
        this.originalTags = originalTags;
    }

    @Generated
    public SideCar getSideCar() {
        return this.sideCar;
    }

    @Generated
    public void setSideCar(SideCar sideCar) {
        this.sideCar = sideCar;
    }

    @Generated
    public long getReceivedBytes() {
        return this.receivedBytes;
    }

    @Generated
    public void setReceivedBytes(long receivedBytes) {
        this.receivedBytes = receivedBytes;
    }

    @Generated
    public long getSentBytes() {
        return this.sentBytes;
    }

    @Generated
    public void setSentBytes(long sentBytes) {
        this.sentBytes = sentBytes;
    }
}

