/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.watermark;

import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.watermark.WatermarkListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatermarkGRPCInterceptor
extends WatermarkListener
implements ServerInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WatermarkGRPCInterceptor.class);
    public static WatermarkGRPCInterceptor INSTANCE;
    private long lastTimestampOfWarningOutput = 0L;

    private WatermarkGRPCInterceptor() {
        super("gRPC-Watermark-Interceptor");
    }

    public static WatermarkGRPCInterceptor create() {
        INSTANCE = new WatermarkGRPCInterceptor();
        return INSTANCE;
    }

    public <REQ, RESP> ServerCall.Listener<REQ> interceptCall(final ServerCall<REQ, RESP> call, Metadata headers, ServerCallHandler<REQ, RESP> next) {
        if (this.isWatermarkExceeded()) {
            call.close(Status.RESOURCE_EXHAUSTED.withDescription("Watermark exceeded"), new Metadata());
            this.logWarning("Watermark exceeded, reject the gRPC request by Circuit Breaking mechanism.");
            return new ServerCall.Listener<REQ>(){};
        }
        ServerCall.Listener delegate = next.startCall(call, headers);
        return new ForwardingServerCallListener.SimpleForwardingServerCallListener<REQ>(delegate){

            public void onMessage(REQ message) {
                if (WatermarkGRPCInterceptor.this.isWatermarkExceeded()) {
                    call.close(Status.RESOURCE_EXHAUSTED.withDescription("Watermark exceeded"), new Metadata());
                    WatermarkGRPCInterceptor.this.logWarning("Watermark exceeded, reject the gRPC request by Circuit Breaking mechanism.");
                    return;
                }
                super.onMessage(message);
            }
        };
    }

    private void logWarning(String message) {
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis - this.lastTimestampOfWarningOutput > 60000L) {
            this.lastTimestampOfWarningOutput = currentTimeMillis;
            log.warn(message);
        }
    }
}

