/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.UnprocessedRequestException;
import com.linecorp.armeria.common.TimeoutException;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.client.dns.DnsUtil;
import io.netty.channel.ConnectTimeoutException;
import io.netty.handler.proxy.ProxyConnectException;

final class TimeoutExceptionPredicate {
    static boolean isTimeoutException(@Nullable Throwable cause) {
        String message;
        if (cause == null) {
            return false;
        }
        if ((cause = TimeoutExceptionPredicate.peel(cause)) instanceof TimeoutException) {
            return true;
        }
        if (cause instanceof ConnectTimeoutException) {
            return true;
        }
        if (cause instanceof ProxyConnectException && (message = cause.getMessage()) != null && message.contains("timeout")) {
            return true;
        }
        return DnsUtil.isDnsQueryTimedOut(cause);
    }

    private static Throwable peel(Throwable cause) {
        if ((cause = Exceptions.peel(cause)) instanceof UnprocessedRequestException) {
            cause = cause.getCause();
        }
        assert (cause != null);
        return cause;
    }

    private TimeoutExceptionPredicate() {
    }
}

