/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.stream;

import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.stream.StreamMessage;
import com.linecorp.armeria.internal.common.stream.ByteBufsInputStream;
import com.linecorp.armeria.internal.common.stream.StreamMessageUtil;
import io.netty.util.concurrent.EventExecutor;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class StreamMessageInputStream<T>
extends InputStream {
    private final StreamMessage<T> source;
    private final EventExecutor executor;
    private final StreamMessageInputStreamSubscriber<T> subscriber;
    private boolean subscribed;
    private boolean closed;

    StreamMessageInputStream(StreamMessage<T> source, Function<? super T, ? extends HttpData> httpDataConverter, EventExecutor executor) {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(httpDataConverter, "httpDataConverter");
        Objects.requireNonNull(executor, "executor");
        this.source = source;
        this.executor = executor;
        this.subscriber = new StreamMessageInputStreamSubscriber<T>(httpDataConverter);
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        this.ensureSubscribed();
        this.maybeRequest();
        return this.byteBufsInputStream().read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        this.ensureSubscribed();
        this.maybeRequest();
        return this.byteBufsInputStream().read(b, off, len);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.source.abort();
        this.byteBufsInputStream().close();
    }

    @Override
    public int available() throws IOException {
        this.ensureOpen();
        return this.byteBufsInputStream().available();
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    private void ensureSubscribed() {
        if (!this.subscribed) {
            this.subscribed = true;
            this.source.subscribe(this.subscriber, this.executor);
            ((StreamMessageInputStreamSubscriber)this.subscriber).whenSubscribed.join();
        }
    }

    private void maybeRequest() throws IOException {
        if (this.available() == 0) {
            this.subscriber.request();
        }
    }

    private ByteBufsInputStream byteBufsInputStream() {
        return ((StreamMessageInputStreamSubscriber)this.subscriber).byteBufsInputStream;
    }

    private static final class StreamMessageInputStreamSubscriber<T>
    implements Subscriber<T> {
        private final Function<? super T, ? extends HttpData> httpDataConverter;
        private final CompletableFuture<Void> whenSubscribed = new CompletableFuture();
        private final ByteBufsInputStream byteBufsInputStream = new ByteBufsInputStream();
        @Nullable
        private volatile Subscription upstream;

        StreamMessageInputStreamSubscriber(Function<? super T, ? extends HttpData> httpDataConverter) {
            Objects.requireNonNull(httpDataConverter, "httpDataConverter");
            this.httpDataConverter = httpDataConverter;
        }

        @Override
        public void onSubscribe(Subscription subscription) {
            Objects.requireNonNull(subscription, "subscription");
            this.upstream = subscription;
            this.whenSubscribed.complete(null);
        }

        @Override
        public void onNext(T item) {
            Objects.requireNonNull(item, "item");
            if (this.byteBufsInputStream.isEos()) {
                StreamMessageUtil.closeOrAbort(item);
                return;
            }
            try {
                HttpData result = this.httpDataConverter.apply(item);
                if (result.isEmpty()) {
                    result.close();
                    this.request();
                    return;
                }
                this.byteBufsInputStream.add(result.byteBuf());
            }
            catch (Throwable ex) {
                StreamMessageUtil.closeOrAbort(item, ex);
                this.onError(ex);
                Subscription upstream = this.upstream;
                assert (upstream != null);
                upstream.cancel();
            }
        }

        @Override
        public void onError(Throwable cause) {
            this.byteBufsInputStream.interrupt(cause);
        }

        @Override
        public void onComplete() {
            this.byteBufsInputStream.setEos();
        }

        public void request() {
            if (this.byteBufsInputStream.isEos()) {
                return;
            }
            Subscription upstream = this.upstream;
            assert (upstream != null);
            upstream.request(1L);
        }
    }
}

