/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common;

import com.linecorp.armeria.common.ContextHolder;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.util.EventLoopCheckingFuture;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractContextAwareFuture<T>
extends EventLoopCheckingFuture<T>
implements ContextHolder {
    private static final Logger logger = LoggerFactory.getLogger(AbstractContextAwareFuture.class);
    private final RequestContext context;

    protected AbstractContextAwareFuture(RequestContext context) {
        this.context = context;
    }

    @Override
    public final RequestContext context() {
        return this.context;
    }

    protected final Runnable makeContextAwareLoggingException(Runnable action) {
        Objects.requireNonNull(action, "action");
        return () -> this.makeContextAwareLoggingException0(action);
    }

    protected final <I> Consumer<I> makeContextAwareLoggingException(Consumer<I> action) {
        Objects.requireNonNull(action, "action");
        return t -> this.makeContextAwareLoggingException0(() -> action.accept(t));
    }

    protected final <I, U> BiConsumer<I, U> makeContextAwareLoggingException(BiConsumer<I, U> action) {
        Objects.requireNonNull(action, "action");
        return (t, u) -> this.makeContextAwareLoggingException0(() -> action.accept(t, u));
    }

    protected final <V> Supplier<V> makeContextAwareLoggingException(Supplier<? extends V> supplier) {
        Objects.requireNonNull(supplier, "supplier");
        return () -> this.makeContextAwareLoggingException0(supplier);
    }

    protected final <I, R> Function<I, R> makeContextAwareLoggingException(Function<I, R> fn) {
        Objects.requireNonNull(fn, "fn");
        return t -> this.makeContextAwareLoggingException0(() -> fn.apply(t));
    }

    protected final <I, U, V> BiFunction<I, U, V> makeContextAwareLoggingException(BiFunction<I, U, V> fn) {
        Objects.requireNonNull(fn, "fn");
        return (t, u) -> this.makeContextAwareLoggingException0(() -> fn.apply(t, u));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeContextAwareLoggingException0(Runnable action) {
        SafeCloseable handle;
        try {
            handle = this.context.push();
        }
        catch (Throwable th) {
            logger.warn("An error occurred while pushing a context", th);
            throw th;
        }
        try {
            action.run();
        }
        finally {
            handle.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> V makeContextAwareLoggingException0(Supplier<? extends V> fn) {
        SafeCloseable handle;
        try {
            handle = this.context.push();
        }
        catch (Throwable th) {
            logger.warn("An error occurred while pushing a context", th);
            throw th;
        }
        try {
            V v = fn.get();
            return v;
        }
        finally {
            handle.close();
        }
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("context", this.context).toString();
    }
}

