/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.bouncycastle.asn1.x509;

import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1Object;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1Primitive;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1Sequence;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1TaggedObject;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.DERSequence;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.x509.GeneralName;
import com.linecorp.armeria.internal.shaded.bouncycastle.util.Strings;

public class GeneralNames
extends ASN1Object {
    private final GeneralName[] names;

    private static GeneralName[] copy(GeneralName[] generalNameArray) {
        GeneralName[] generalNameArray2 = new GeneralName[generalNameArray.length];
        System.arraycopy(generalNameArray, 0, generalNameArray2, 0, generalNameArray.length);
        return generalNameArray2;
    }

    public static GeneralNames getInstance(Object object) {
        if (object instanceof GeneralNames) {
            return (GeneralNames)object;
        }
        if (object != null) {
            return new GeneralNames(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public static GeneralNames getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return new GeneralNames(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public GeneralNames(GeneralName[] generalNameArray) {
        this.names = GeneralNames.copy(generalNameArray);
    }

    private GeneralNames(ASN1Sequence aSN1Sequence) {
        this.names = new GeneralName[aSN1Sequence.size()];
        for (int i = 0; i != aSN1Sequence.size(); ++i) {
            this.names[i] = GeneralName.getInstance(aSN1Sequence.getObjectAt(i));
        }
    }

    public GeneralName[] getNames() {
        return GeneralNames.copy(this.names);
    }

    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(this.names);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = Strings.lineSeparator();
        stringBuffer.append("GeneralNames:");
        stringBuffer.append(string);
        for (int i = 0; i != this.names.length; ++i) {
            stringBuffer.append("    ");
            stringBuffer.append(this.names[i]);
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

