/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.reflections.adapters;

import com.linecorp.armeria.internal.shaded.guava.collect.Lists;
import com.linecorp.armeria.internal.shaded.reflections.ReflectionsException;
import com.linecorp.armeria.internal.shaded.reflections.adapters.MetadataAdapter;
import com.linecorp.armeria.internal.shaded.reflections.util.Utils;
import com.linecorp.armeria.internal.shaded.reflections.vfs.Vfs;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.annotation.Annotation;

public class JavassistAdapter
implements MetadataAdapter<ClassFile, FieldInfo, MethodInfo> {
    public static boolean includeInvisibleTag = true;

    @Override
    public List<String> getClassAnnotationNames(ClassFile aClass) {
        return this.getAnnotationNames((AnnotationsAttribute)aClass.getAttribute("RuntimeVisibleAnnotations"), includeInvisibleTag ? (AnnotationsAttribute)aClass.getAttribute("RuntimeInvisibleAnnotations") : null);
    }

    @Override
    public ClassFile getOfCreateClassObject(Vfs.File file) {
        InputStream inputStream = null;
        try {
            inputStream = file.openInputStream();
            DataInputStream dis = new DataInputStream(new BufferedInputStream(inputStream));
            ClassFile classFile = new ClassFile(dis);
            return classFile;
        }
        catch (IOException e) {
            throw new ReflectionsException("could not create class file from " + file.getName(), e);
        }
        finally {
            Utils.close(inputStream);
        }
    }

    @Override
    public String getClassName(ClassFile cls) {
        return cls.getName();
    }

    @Override
    public String getSuperclassName(ClassFile cls) {
        return cls.getSuperclass();
    }

    @Override
    public List<String> getInterfacesNames(ClassFile cls) {
        return Arrays.asList(cls.getInterfaces());
    }

    @Override
    public boolean acceptsInput(String file) {
        return file.endsWith(".class");
    }

    private List<String> getAnnotationNames(AnnotationsAttribute ... annotationsAttributes) {
        ArrayList<String> result = Lists.newArrayList();
        if (annotationsAttributes != null) {
            for (AnnotationsAttribute annotationsAttribute : annotationsAttributes) {
                if (annotationsAttribute == null) continue;
                for (Annotation annotation : annotationsAttribute.getAnnotations()) {
                    result.add(annotation.getTypeName());
                }
            }
        }
        return result;
    }
}

