/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.healthcheck;

import com.linecorp.armeria.common.CommonPools;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.server.healthcheck.CpuHealthChecker;
import com.linecorp.armeria.server.healthcheck.HealthCheckStatus;
import com.linecorp.armeria.server.healthcheck.ListenableHealthChecker;
import com.linecorp.armeria.server.healthcheck.ScheduledHealthChecker;
import io.netty.util.concurrent.EventExecutor;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;

@FunctionalInterface
public interface HealthChecker {
    @UnstableApi
    public static ListenableHealthChecker of(Supplier<? extends CompletionStage<HealthCheckStatus>> healthChecker, Duration fallbackTtl) {
        return HealthChecker.of(healthChecker, fallbackTtl, CommonPools.workerGroup().next());
    }

    @UnstableApi
    public static ListenableHealthChecker of(Supplier<? extends CompletionStage<HealthCheckStatus>> healthChecker, Duration fallbackTtl, EventExecutor eventExecutor) {
        Objects.requireNonNull(fallbackTtl, "fallbackTtl");
        Preconditions.checkArgument(!fallbackTtl.isNegative() && !fallbackTtl.isZero(), "fallbackTtl: %s (expected: > 0)", (Object)fallbackTtl);
        return new ScheduledHealthChecker(Objects.requireNonNull(healthChecker, "healthChecker"), fallbackTtl, Objects.requireNonNull(eventExecutor, "eventExecutor"));
    }

    public static HealthChecker ofCpu(double targetSystemCpuUsage, double targetProcessCpuUsage) {
        return new CpuHealthChecker(targetSystemCpuUsage, targetProcessCpuUsage);
    }

    public boolean isHealthy();
}

