/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.observation;

import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogAccess;
import com.linecorp.armeria.common.logging.RequestLogProperty;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.observation.HttpServiceObservationDocumentation;
import com.linecorp.armeria.server.observation.ServiceObservationContext;
import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import java.net.InetSocketAddress;

final class DefaultServiceObservationConvention
implements ObservationConvention<ServiceObservationContext> {
    static final DefaultServiceObservationConvention INSTANCE = new DefaultServiceObservationConvention();

    DefaultServiceObservationConvention() {
    }

    @Override
    public KeyValues getLowCardinalityKeyValues(ServiceObservationContext context) {
        ServiceRequestContext ctx = context.requestContext();
        int expectedSize = 1;
        KeyValue protocol = null;
        KeyValue serializationFormat = null;
        KeyValue statusCode = null;
        if (context.getResponse() != null) {
            RequestLog log = ctx.log().ensureComplete();
            protocol = HttpServiceObservationDocumentation.LowCardinalityKeys.HTTP_PROTOCOL.withValue(DefaultServiceObservationConvention.protocol(log));
            statusCode = HttpServiceObservationDocumentation.LowCardinalityKeys.STATUS_CODE.withValue(log.responseStatus().codeAsText());
            expectedSize = 3;
            String serFmt = DefaultServiceObservationConvention.serializationFormat(log);
            if (serFmt != null) {
                expectedSize = 4;
                serializationFormat = HttpServiceObservationDocumentation.LowCardinalityKeys.HTTP_SERIALIZATION_FORMAT.withValue(serFmt);
            }
        }
        ImmutableList.Builder<KeyValue> builder = ImmutableList.builderWithExpectedSize(expectedSize);
        builder.add((Object)HttpServiceObservationDocumentation.LowCardinalityKeys.HTTP_METHOD.withValue(ctx.method().name()));
        this.addIfNotNull(protocol, builder);
        this.addIfNotNull(statusCode, builder);
        this.addIfNotNull(serializationFormat, builder);
        return KeyValues.of(builder.build());
    }

    private void addIfNotNull(@Nullable KeyValue keyValue, ImmutableList.Builder<KeyValue> builder) {
        if (keyValue != null) {
            builder.add((Object)keyValue);
        }
    }

    @Override
    public KeyValues getHighCardinalityKeyValues(ServiceObservationContext context) {
        ServiceRequestContext ctx = context.requestContext();
        int expectedSize = 3;
        KeyValue addressRemote = null;
        KeyValue addressLocal = null;
        KeyValue error = null;
        if (context.getResponse() != null) {
            Throwable responseCause;
            InetSocketAddress laddr;
            RequestLog log = ctx.log().ensureComplete();
            InetSocketAddress raddr = ctx.remoteAddress();
            if (raddr != null) {
                ++expectedSize;
                addressRemote = HttpServiceObservationDocumentation.HighCardinalityKeys.ADDRESS_REMOTE.withValue(raddr.toString());
            }
            if ((laddr = ctx.localAddress()) != null) {
                ++expectedSize;
                addressLocal = HttpServiceObservationDocumentation.HighCardinalityKeys.ADDRESS_LOCAL.withValue(laddr.toString());
            }
            if ((responseCause = log.responseCause()) != null) {
                ++expectedSize;
                error = HttpServiceObservationDocumentation.HighCardinalityKeys.ERROR.withValue(responseCause.toString());
            } else if (log.responseStatus().isError()) {
                ++expectedSize;
                error = HttpServiceObservationDocumentation.HighCardinalityKeys.ERROR.withValue(log.responseStatus().codeAsText());
            }
        }
        ImmutableList.Builder<KeyValue> builder = ImmutableList.builderWithExpectedSize(expectedSize);
        builder.add(new KeyValue[]{HttpServiceObservationDocumentation.HighCardinalityKeys.HTTP_PATH.withValue(ctx.path()), HttpServiceObservationDocumentation.HighCardinalityKeys.HTTP_HOST.withValue(MoreObjects.firstNonNull(context.httpRequest().authority(), "UNKNOWN")), HttpServiceObservationDocumentation.HighCardinalityKeys.HTTP_URL.withValue(ctx.uri().toString())});
        this.addIfNotNull(addressRemote, builder);
        this.addIfNotNull(addressLocal, builder);
        this.addIfNotNull(error, builder);
        return KeyValues.of(builder.build());
    }

    private static String protocol(RequestLog requestLog) {
        return requestLog.sessionProtocol().uriText();
    }

    @Nullable
    private static String serializationFormat(RequestLog requestLog) {
        SerializationFormat serFmt = requestLog.serializationFormat();
        return serFmt == SerializationFormat.NONE ? null : serFmt.uriText();
    }

    @Override
    public String getName() {
        return "http.server.requests";
    }

    @Override
    public String getContextualName(ServiceObservationContext context) {
        RequestLogAccess logAccess = context.requestContext().log();
        if (logAccess.isAvailable(RequestLogProperty.NAME)) {
            return logAccess.partial().fullName();
        }
        return context.getName();
    }

    @Override
    public boolean supportsContext(Observation.Context context) {
        return context instanceof ServiceObservationContext;
    }
}

