/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.zabbix.provider.protocol;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import lombok.Generated;
import org.apache.skywalking.oap.server.receiver.zabbix.provider.ZabbixMetrics;
import org.apache.skywalking.oap.server.receiver.zabbix.provider.ZabbixModuleConfig;
import org.apache.skywalking.oap.server.receiver.zabbix.provider.protocol.ZabbixProtocolDataCodec;
import org.apache.skywalking.oap.server.receiver.zabbix.provider.protocol.ZabbixProtocolHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZabbixServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZabbixServer.class);
    private final ZabbixModuleConfig config;
    private final ZabbixMetrics metrics;
    private NioEventLoopGroup bossGroup;
    private NioEventLoopGroup workerGroup;
    private Channel serverChannel;

    public ZabbixServer(ZabbixModuleConfig config, ZabbixMetrics metrics) {
        this.config = config;
        this.metrics = metrics;
    }

    public void start() throws Exception {
        this.bossGroup = new NioEventLoopGroup(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("TCP-BOSS-THREAD-%d").build());
        this.workerGroup = new NioEventLoopGroup(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("TCP-WORKER-THREAD-%d").build());
        ServerBootstrap bootstrap = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)this.bossGroup, (EventLoopGroup)this.workerGroup).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel channel) throws Exception {
                ZabbixServer.this.initChannel(channel);
            }
        });
        this.serverChannel = bootstrap.bind(this.config.getHost(), this.config.getPort()).sync().channel();
        log.info("Zabbix receiver started at port: {}", (Object)this.config.getPort());
    }

    protected void initChannel(SocketChannel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addLast(new ChannelHandler[]{new ZabbixProtocolDataCodec()});
        pipeline.addLast(new ChannelHandler[]{new ZabbixProtocolHandler(this.metrics)});
    }

    public void stop() {
        this.serverChannel.close().syncUninterruptibly();
    }
}

