/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.grpc;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.server.grpc.AbstractServerCall;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.server.grpc.AsyncServerInterceptor;
import com.linecorp.armeria.server.grpc.ServerCallUtil;
import io.grpc.ServerCall;
import io.netty.util.concurrent.EventExecutor;
import java.util.ArrayDeque;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

final class DeferredListener<I>
extends ServerCall.Listener<I> {
    @Nullable
    private final Executor blockingExecutor;
    @Nullable
    private final EventExecutor eventLoop;
    @Nullable
    private ArrayDeque<Consumer<ServerCall.Listener<I>>> pendingQueue = new ArrayDeque();
    @Nullable
    private ServerCall.Listener<I> delegate;
    private boolean callClosed;

    DeferredListener(ServerCall<I, ?> serverCall, CompletableFuture<ServerCall.Listener<I>> listenerFuture) {
        AbstractServerCall<I, ?> armeriaServerCall = ServerCallUtil.findArmeriaServerCall(serverCall);
        Preconditions.checkState((armeriaServerCall != null ? 1 : 0) != 0, (String)"Cannot use %s with a non-Armeria gRPC server. ServerCall: %s", (Object)AsyncServerInterceptor.class.getName(), serverCall);
        this.blockingExecutor = armeriaServerCall.blockingExecutor();
        this.eventLoop = this.blockingExecutor == null ? armeriaServerCall.eventLoop() : null;
        listenerFuture.handleAsync((delegate, cause) -> {
            if (cause != null) {
                this.callClosed = true;
                armeriaServerCall.close((Throwable)cause);
                return null;
            }
            this.delegate = delegate;
            assert (this.pendingQueue != null);
            try {
                Consumer<ServerCall.Listener<I>> task;
                while ((task = this.pendingQueue.poll()) != null) {
                    task.accept((ServerCall.Listener<I>)delegate);
                }
            }
            catch (Throwable ex) {
                this.callClosed = true;
                armeriaServerCall.close(ex);
                Object var5_6 = null;
                return var5_6;
            }
            finally {
                this.pendingQueue = null;
            }
            return null;
        }, this.sequentialExecutor());
    }

    public void onMessage(I message) {
        this.maybeAddPendingTask(listener -> listener.onMessage(message));
    }

    public void onHalfClose() {
        this.maybeAddPendingTask(ServerCall.Listener::onHalfClose);
    }

    public void onCancel() {
        this.maybeAddPendingTask(ServerCall.Listener::onCancel);
    }

    public void onComplete() {
        this.maybeAddPendingTask(ServerCall.Listener::onComplete);
    }

    public void onReady() {
        this.maybeAddPendingTask(ServerCall.Listener::onReady);
    }

    private void maybeAddPendingTask(Consumer<ServerCall.Listener<I>> task) {
        if (this.callClosed) {
            return;
        }
        if (!this.shouldBePending()) {
            task.accept(this.delegate);
            return;
        }
        if (this.eventLoop != null && this.eventLoop.inEventLoop()) {
            this.addPendingTask(task);
        } else {
            this.sequentialExecutor().execute(() -> {
                if (this.callClosed) {
                    return;
                }
                if (!this.shouldBePending()) {
                    task.accept(this.delegate);
                } else {
                    this.addPendingTask(task);
                }
            });
        }
    }

    private void addPendingTask(Consumer<ServerCall.Listener<I>> task) {
        assert (this.pendingQueue != null);
        this.pendingQueue.add(task);
    }

    private boolean shouldBePending() {
        return this.delegate == null;
    }

    private Executor sequentialExecutor() {
        return (Executor)MoreObjects.firstNonNull((Object)this.eventLoop, (Object)this.blockingExecutor);
    }
}

